static char rcsid[] = "$Id: RockerSwitch.c,v 1.4 1999/08/26 17:22:06 falk Exp $";

/*
 * RockerSwitch.c - RockerSwitch widget
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Misc.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xmu/Drawing.h>

#include "RockerSwitchP.h"
#include "Gcs.h"

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

static char defaultTranslations[] =
	"<EnterWindow>:		highlight()	\n\
	 <FocusIn>:		highlight()	\n\
	 <LeaveWindow>:		reset()		\n\
	 <FocusOut>:		reset()		\n\
	 <BtnDown>:		switch(down)	\n\
	 <BtnUp>:		switch(up)	\n\
	 <KeyDown>space:	switch(down)	\n\
	 <KeyUp>space:		switch(up)	";

#define offset(field) XtOffsetOf(RockerSwitchRec, rockerSwitch.field)
static XtResource resources[] = {
  {XtNbackground, XtCBackground, XtRPixel, sizeof(Pixel),
      XtOffsetOf(RockerSwitchRec, core.background_pixel), XtRString, "black"},
  {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
      offset(foreground), XtRString, "grey"},
  {XtNbeNiceToColormap, XtCBeNiceToColormap, XtRBoolean, sizeof(Boolean),
      offset(beNiceToColormap), XtRImmediate, (XtPointer) True},
  {XtNtopShadowContrast, XtCTopShadowContrast, XtRInt, sizeof(int),
      offset(topShadowContrast), XtRImmediate, (XtPointer) 10},
  {XtNbottomShadowContrast, XtCBottomShadowContrast, XtRInt, sizeof(int),
      offset(botShadowContrast), XtRImmediate, (XtPointer) 40},
};
#undef offset

	/* class methods */

static	void	RockerSwitchRealize() ;
static	void	RockerSwitchExpose() ;
static	Boolean RockerSwitchSet();
static	void	RockerSwitchDestroy() ;


	/* private */

static	void	rockerSwitchGetGcs() ;
static	void	rockerSwitchFreeGcs() ;

#define SuperClass ((ButtonWidgetClass)&buttonClassRec)

RockerSwitchClassRec rockerSwitchClassRec = {
  {
    (WidgetClass) SuperClass,		/* superclass		*/
    "RockerSwitch",			/* class_name		*/
    sizeof(RockerSwitchRec),		/* size			*/
    NULL,				/* class_initialize	*/
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		*/
    NULL,				/* initialize		*/
    NULL,				/* initialize_hook	*/
    RockerSwitchRealize,		/* realize		*/
    NULL,				/* actions		*/
    0,					/* num_actions		*/
    resources,				/* resources		*/
    XtNumber(resources),		/* resource_count	*/
    NULLQUARK,				/* xrm_class		*/
    FALSE,				/* compress_motion	*/
    TRUE,				/* compress_exposure	*/
    TRUE,				/* compress_enterleave	*/
    FALSE,				/* visible_interest	*/
    RockerSwitchDestroy,			/* destroy		*/
    XtInheritResize,			/* resize		*/
    RockerSwitchExpose,			/* expose		*/
    RockerSwitchSet,				/* set_values		*/
    NULL,				/* set_values_hook	*/
    XtInheritSetValuesAlmost,		/* set_values_almost	*/
    NULL,				/* get_values_hook	*/
    NULL,				/* accept_focus		*/
    XtVersion,				/* version		*/
    NULL,				/* callback_private	*/
    defaultTranslations,		/* tm_table		*/
    XtInheritQueryGeometry,		/* query_geometry	*/
    XtInheritDisplayAccelerator,	/* display_accelerator	*/
    NULL				/* extension		*/
  },  /* CoreClass fields initialization */
  {
    XtInheritChangeState,		/* change_state		*/
    NULL,				/* extension		*/
  },  /* ButtonClass fields initialization */
  {
    NULL,				/* extension		*/
  },  /* RockerSwitchClass fields initialization */
};


  /* for public consumption */
WidgetClass rockerSwitchWidgetClass = (WidgetClass) &rockerSwitchClassRec;


/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/




static	void
RockerSwitchRealize(w, valueMask, attributes)
    Widget w;
    Mask *valueMask;
    XSetWindowAttributes *attributes;
{
    SuperClass->core_class.realize(w, valueMask, attributes);
    rockerSwitchGetGcs((RockerSwitchWidget)w) ;
}



	/* This function draws a simple toggle switch.  Voted
	 * "most likely to be redefined in a subclass of this widget"
	 */

/* ARGSUSED */
static	void
RockerSwitchExpose(w, event, region)
  Widget w;
  XEvent *event;
  Region region;
{
  RockerSwitchWidget rw = (RockerSwitchWidget)w ;
  Display *dpy = XtDisplay(w) ;
  Window win = XtWindow(w) ;
  GC gc ;
  int y = rw->core.height/4;
  int hgt ;

  gc = rw->button.state & Highlit ?
  	rw->rockerSwitch.hlGC : rw->rockerSwitch.fgGC ;

  if( rw->button.set )
    y = rw->core.height - y ;

  hgt = rw->core.height - y ;

  XFillRectangle(dpy,win,gc, 0,0, rw->core.width,y);
  XFillRectangle(dpy,win,rw->rockerSwitch.shadowGC, 0,y, rw->core.width, hgt) ;

  /* draw some more decorations */
  if( rw->button.set ) {
    y /= 2 ;
    XDrawLine(dpy,win,rw->rockerSwitch.shadowGC, 0,y, rw->core.width,y) ;
    XDrawLine(dpy,win,rw->rockerSwitch.hlGC, 0,y+1, rw->core.width,y+1) ;
  }
  else {
    y += hgt/2 ;
    XDrawLine(dpy,win,rw->rockerSwitch.shadowGC, 0,y, rw->core.width,y) ;
    XDrawLine(dpy,win,rw->rockerSwitch.fgGC, 0,y+1, rw->core.width,y+1) ;
  }

  /* inactive? */
  if( !XtIsSensitive(w) && rw->rockerSwitch.greyGC != NULL )
    XFillRectangle(dpy, win, rw->rockerSwitch.greyGC,
      0,0, rw->core.width, rw->core.height) ;
}



/*
 * Set specified arguments into widget
 */

/* ARGSUSED */
static Boolean
RockerSwitchSet(current, request, new, args, num_args)
  Widget current, request, new;
  ArgList args;
  Cardinal *num_args;
{
  RockerSwitchWidget oldrw = (RockerSwitchWidget) current;
  RockerSwitchWidget rw = (RockerSwitchWidget) new;
  Boolean redisplay = False;

  if(oldrw->core.background_pixel != rw->core.background_pixel		||
     oldrw->rockerSwitch.foreground != rw->rockerSwitch.foreground	||
     oldrw->rockerSwitch.beNiceToColormap !=
     				rw->rockerSwitch.beNiceToColormap	||
     oldrw->rockerSwitch.topShadowContrast !=
     				rw->rockerSwitch.topShadowContrast	||
     oldrw->rockerSwitch.botShadowContrast !=
     				rw->rockerSwitch.botShadowContrast	)
  {
    if( XtIsRealized(new) ) {
      rockerSwitchFreeGcs(rw) ;
      rockerSwitchGetGcs(rw) ;
    }
    redisplay = True ;
  }

  return redisplay;
}


static	void
RockerSwitchDestroy(w)
  Widget w;
{
  RockerSwitchWidget rw = (RockerSwitchWidget) w;
  rockerSwitchFreeGcs(rw) ;
}










	/* Private utilities */

static	void
rockerSwitchGetGcs(rw)
  RockerSwitchWidget rw;
{
  Widget	w = (Widget)rw ;
  XGCValues	values ;
  u_long	vmask, dcmask ;
  Pixmap	pm50 ;

  rw->rockerSwitch.fgGC = AllocFgGC(w, rw->rockerSwitch.foreground, None) ;
  rw->rockerSwitch.hlGC = AllocGreyGC(w, rw->rockerSwitch.foreground, None,
	100 + rw->rockerSwitch.topShadowContrast,
	rw->rockerSwitch.beNiceToColormap) ;
  rw->rockerSwitch.shadowGC = AllocGreyGC(w, rw->rockerSwitch.foreground, None,
	100 - rw->rockerSwitch.botShadowContrast,
	rw->rockerSwitch.beNiceToColormap) ;

  pm50 = XmuCreateStippledPixmap(XtScreen(w), 1L,0L, 1) ;
  values.fill_style = FillStippled ;
  values.foreground = w->core.background_pixel ;
  values.stipple = pm50 ;
  vmask = GCForeground|GCStipple|GCFillStyle ;
  dcmask = GCFont|GCSubwindowMode|GCGraphicsExposures|GCDashOffset|
		GCDashList|GCArcMode ;
  rw->rockerSwitch.greyGC =
  	XtAllocateGC(w, w->core.depth, vmask, &values, 0L, dcmask) ;
}


static	void
rockerSwitchFreeGcs(rw)
  RockerSwitchWidget rw;
{
  Widget w = (Widget)rw ;
  if( rw->rockerSwitch.fgGC != NULL ) {
    XtReleaseGC(w, rw->rockerSwitch.fgGC) ;
    XtReleaseGC(w, rw->rockerSwitch.hlGC) ;
    XtReleaseGC(w, rw->rockerSwitch.shadowGC) ;
    XtReleaseGC(w, rw->rockerSwitch.greyGC) ;
  }
}
