/* $Id: RockerSwitchP.h,v 1.1 1999/08/18 17:13:30 falk Exp $
 *
 * RockerSwitchP.h - Private definitions of RockerSwitch widget
 */

#ifndef _ROCKERSWITCHP_H
#define _ROCKERSWITCHP_H

#include "ButtonP.h"
#include "RockerSwitch.h"


typedef struct _RockerSwitchClass {
    XtPointer	extension ;
} RockerSwitchClassPart;

   /* Full class record declaration */
typedef struct _RockerSwitchClassRec {
    CoreClassPart	core_class;
    ButtonClassPart	button_class;
    RockerSwitchClassPart	rockerSwitch_class;
} RockerSwitchClassRec;

extern	RockerSwitchClassRec	rockerSwitchClassRec;

/***************************************
 *
 *  Instance (widget) structure 
 *
 **************************************/

    /* New fields for the RockerSwitch widget record */
typedef struct {
    /* resources */
    Pixel	foreground ;
    Boolean	beNiceToColormap ;
    int		topShadowContrast ;
    int		botShadowContrast ;

    /* private state */
    GC		fgGC, hlGC, shadowGC ;
    GC		greyGC ;
} RockerSwitchPart;


   /* Full widget declaration */
typedef struct _RockerSwitchRec {
    CorePart	core;
    ButtonPart	button;
    RockerSwitchPart	rockerSwitch;
} RockerSwitchRec;

#endif /* _ROCKERSWITCHP_H */


