static char rcsid[] = "$Id: buttondemo.c,v 1.2 1999/08/25 17:14:43 falk Exp $" ;

#include <stdio.h>

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Core.h>
#include <X11/Object.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>

#include "RockerSwitch.h"
#include "XpmButton.h"

	/* X11 stuff */

static	Display	*dpy ;
static	Atom	wm_protocols ;
static	Atom	wm_delete_window ;

	/* Xt stuff */

static	XtAppContext	app_ctx ;

static	Widget	topLevel, button1, button2, button3, button4, button5, button6 ;

static String fallback[] = {
	"Buttondemo.baseTranslations: <Message>WM_PROTOCOLS: WMProtocols()",
	"*borderWidth: 0",
	NULL
};

static	void	WMProtocols(Widget, XEvent *, String *, Cardinal *) ;

static	void	ButtonCB(Widget btn, XtPointer client, XtPointer data) ;
static	void	ButtonStateCB(Widget btn, XtPointer client, XtPointer data) ;


	/* define global actions table for the application.  This is done
	 * to catch messages.  This could also be done through the main
	 * event loop if we wrote one.  It would be nice if Xt had a way
	 * of regestering a callback proc for specific kinds of events.
	 */

XtActionsRec	fd_actions[] = {
    {"WMProtocols", WMProtocols},
} ;


int
main(int argc, char **argv)
{
	Widget	box ;

	topLevel = XtAppInitialize(&app_ctx, "Buttondemo", NULL,0,
		&argc,argv, fallback, NULL,0) ;
	dpy = XtDisplay(topLevel) ;

	XtAppAddActions(app_ctx, fd_actions, XtNumber(fd_actions));

	box = XtVaCreateManagedWidget("panel", boxWidgetClass, topLevel, 0) ;

	button1 = XtVaCreateManagedWidget("button1",
		rockerSwitchWidgetClass, box, 0) ;
	XtAddCallback(button1, XtNcallback, ButtonCB, NULL) ;
	XtAddCallback(button1, XtNstateCallback, ButtonStateCB, NULL) ;

	button2 = XtVaCreateManagedWidget("button2",
		rockerSwitchWidgetClass, box, 0) ;
	XtAddCallback(button2, XtNcallback, ButtonCB, NULL) ;
	XtAddCallback(button2, XtNstateCallback, ButtonStateCB, NULL) ;

	button3 = XtVaCreateManagedWidget("button3",
		rockerSwitchWidgetClass, box, 0) ;
	XtAddCallback(button3, XtNcallback, ButtonCB, NULL) ;
	XtAddCallback(button3, XtNstateCallback, ButtonStateCB, NULL) ;

	button4 = XtVaCreateManagedWidget("button4",
		xpmButtonWidgetClass, box, 0) ;
	XtAddCallback(button4, XtNcallback, ButtonCB, NULL) ;
	XtAddCallback(button4, XtNstateCallback, ButtonStateCB, NULL) ;

	button5 = XtVaCreateManagedWidget("button5",
		xpmButtonWidgetClass, box, 0) ;
	XtAddCallback(button5, XtNcallback, ButtonCB, NULL) ;
	XtAddCallback(button5, XtNstateCallback, ButtonStateCB, NULL) ;

	button6 = XtVaCreateManagedWidget("button6",
		xpmButtonWidgetClass, box, 0) ;
	XtAddCallback(button6, XtNcallback, ButtonCB, NULL) ;
	XtAddCallback(button6, XtNstateCallback, ButtonStateCB, NULL) ;

	XtRealizeWidget(topLevel) ;

	/* tell window system we're willing to handle window-delete messages */
	wm_protocols = XInternAtom(dpy, "WM_PROTOCOLS", False);
	wm_delete_window = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
	(void) XSetWMProtocols(dpy, XtWindow(topLevel), &wm_delete_window,1);

	XtAppMainLoop(app_ctx) ;

	exit(0) ;
	/* NOTREACHED */
}






/* ARGSUSED */
static	void
WMProtocols(w, ev, params, nparams)
	Widget	w ;
	XEvent	*ev ;
	String	*params ;
	Cardinal *nparams ;
{
	if( ev->type == ClientMessage  &&
	    ev->xclient.message_type == wm_protocols  &&
	    ev->xclient.data.l[0] == wm_delete_window )
	{
	  if( w == topLevel )
	    exit(0) ;
	}
}


static	void
ButtonCB(Widget btn, XtPointer client, XtPointer data)
{
  printf("button %s %d\n", XtName(btn), (int)data) ;
  if( btn == button3 ) {
    XtSetSensitive(button4, (int)data) ;
    XtSetSensitive(button5, (int)data) ;
    XtSetSensitive(button6, (int)data) ;
  }
  else if( btn == button6 ) {
    XtSetSensitive(button1, (int)data) ;
    XtSetSensitive(button2, (int)data) ;
    XtSetSensitive(button3, (int)data) ;
  }
}


static	void
ButtonStateCB(Widget btn, XtPointer client, XtPointer data)
{
  u_int flags = (u_int)data ;
  printf("%s:", XtName(btn)) ;
  if( flags == 0 ) printf(" nothing") ;
  if( flags & Set ) printf(" set") ;
  if( flags & Highlit ) printf(" highlit") ;
  if( flags & Armed ) printf(" armed") ;
  putchar('\n') ;
}
