'\" t
." $Id: Gridbox.man,v 1.5 1999/07/30 17:19:59 falk Exp $
." view with "tbl | nroff -man"
."
.TH "Gridbox" 3 "Aug 1998" "Version 1.0" ""
.SH NAME
Gridbox
.SH DESCRIPTION
The Gridbox widget manages one or more child widgets, arranging them in
a grid of cells, aligned vertically and horizontally.  Rows
and columns may be different sizes, depending on the needs of the
widgets they contain.
.LP
Child widgets may span any number of rows and/or columns of the grid,
allowing highly flexible layout policies.
Child widgets may have \fIweights\fP specified, which control
how the child widgets are resized when the parent Gridbox is resized.

.SH CLASS
Compound => Constraint => Gridbox

Gridbox does not require any specific widget set, and may be combined with
any other widget set.

.SH RESOURCES

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Gridbox
Name	Class	Type	Default
defaultDistance	Thickness	Dimension	4
.TE
.ps +2

.LP
See the \fBCore, Composite,\fP and \fBConstraint\fP
widgets for more resources.

.SS Descriptions.

.TP
.B defaultDistance
Specifies the margins around child widgets.


.SH CONSTRAINT RESOURCES

Constraint resources are set for the individual child widgets.

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Gridbox Constraints
Name	Class	Type	Default
gridx	Position	Position	0
gridy	Position	Position	0
gridWidth	Width	Dimension	1
gridHeight	Height	Dimension	1
fill	Fill	FillType	both
gravity	Gravity	int	Center
weightx	Weight	int	0
weighty	Weight	int	0
margin	Margin	int	defaultDistance
.TE
.ps +2

.SS Descriptions.

.TP
.B gridx, gridy
The widget's position in the grid.  Upper-left corner is 0,0
.TP
.B gridWidth, gridHeight
Widget size in cells.
.TP
.B fill
Determines how the widget is resized to fill its cell.  Value
may be any of \fBnone\fP, \fBwidth\fP, \fBheight\fP, and \fBboth\fP.
.TP
.B gravity
Determines how the widget is positioned within its cell.
Acceptable values are
\fBNorthWest, North, NorthEast, West, Center, East, SouthWest, South,\fP
and
\fBSouthEast\fP.
This resource has no effect if the widget's \fBfill\fP resource is "both".
.TP
.B weightx, weighty
Determines how the widget's cell is resized in response to Gridbox resize.
When the gridbox is resized, any extra space is distributed to the
rows and columns based on weight.
.IP
Each row and column in the grid has a weight which is the maximum
weight of all the widgets in that row or column.  Whenever the Gridbox
is larger than the size required to contain all of the child widgets,
the excess space is distributed to each row or column in proportion to
that row or column's weight.
.IP
If all weights are zero, the rows and columns are not resized.


.SH PROGRAMMING TIPS
Every child of a Gridbox widget must be assigned \fBgridx\fP
and \fBgridy\fP
constraints, or they will all overlap each other in the upper-left corner
of the Gridbox.
.LP
\fINote:\fP unless, of course, this is what you want.  If all Gridbox
children are assigned the same cell, with \fBfill\fP set to \fBboth\fP,
they will also be assigned the same dimensions.  You could then control
their visibility by altering their stacking order.
.LP
A menu bar may be created in Athena through the use of a grid box:
.IP 1
Create a gridbox
.IP 2
Create a MenuButton for each menu.  Set the \fBborderWidth\fP
and \fBshadowWidth\fP
of all MenuButtons to zero.  Set \fBgridx\fP to the button's position
in the menu bar.  Set \fBgridy\fP to zero.
.IP 3
The "Help" MenuButton is given a \fBweightx\fP constraint of 1 so that its
cell will fill the rest of the menu bar.  The \fBfill\fP constraint is set
to \fBnone\fP so that the button is not resized.  The \fBgravity\fP constraint
is set to \fBeast\fP so that the button is at the east end of the menu bar.
.IP
Alternatively, a blank label widget (or perhaps one containing a logo) is
placed between the left buttons and the Help button, and allowed to fill
the available space.
.LP
A note on geometry management:  In the intrinsics library, widget layout
and sizing is done through negotiation.  A widget asks to be a certain
size, and its manager either grants the request, denies it, or
offers a compromise.  The requesting widget may then ask for the compromise.
.LP
When a widget's \fBfill\fP constraint resource is set to anything but
\fBnone\fP, it will most likely be offerred a size compromise larger than
it requested.  Most widgets will accept the compromise.
.LP
Some widgets, for example the Athena Label widget, never accept compromises.
Further, the Label widget always asks to be resized whenever its
label changes.  As a result of all this, \fBfill\fP constraint of
an Athena Label -- and probably other widgets as well -- should be set
to \fBnone\fP if you encounter problems with widget resizing.


.SH BUGS

Motif keyboard traversal may not work within Gridbox.  Motif Text
widgets may not work properly for this reason.


.SH AUTHOR
Edward Falk <falk@falconer.vip.best.com>

.SH COPYRIGHT
Copyright 1999 by Edward A. Falk.  This widget may be used freely in any
software.  Source code is freely distributable provided that my name
is not removed from it.
.P
The X Consortium, and any party obtaining a copy of these files
from the X Consortium, directly or indirectly, is granted, free of
charge, a full and unrestricted irrevocable, world-wide, paid up,
royalty-free, nonexclusive right and license to deal in this
software and documentation files (the "Software"), including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons who receive copies from any such party to do so.


