#include <Xm/Xm.h>
#include "../plot_widgets/2DHist.h"

#define NUM_X_BINS     20
#define NUM_Y_BINS     20

static float bins[NUM_X_BINS][NUM_Y_BINS] = {
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0},
    {0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0},
    {0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0},
    {0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0},
    {0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0},
    {0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0},
    {0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0},
    {0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0},
    {0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0},
    {0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0},
    {0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
   
main(int argc, char *argv[])
{
    XtAppContext app_context;
    Widget toplevel, w;
    XmString xmstr;
    h2DHistSetup hist;    
    
    /* Initialize the Intrinsics */
    toplevel = XtAppInitialize(&app_context, "CurvesTest", NULL,
	    0, &argc, argv, NULL, NULL, 0);    	
    
    /* Create a hist2D widget */
    w = XtVaCreateManagedWidget("2DHist", hist2DWidgetClass, toplevel, NULL);
    	
    /* Create the histogram data structure */ 
    hist.nXBins = NUM_X_BINS;
    hist.nYBins = NUM_Y_BINS;
    hist.xMin = -1.0;
    hist.xMax = 1.0;
    hist.yMin = -1.0;
    hist.yMax = 1.0;
    hist.xScaleType = H2D_LINEAR;
    hist.xScaleBase = 0.0;
    hist.yScaleType = H2D_LINEAR;
    hist.yScaleBase = 0.0;
    hist.xLabel = "This is the X axis label";
    hist.yLabel = "This is the Y axis label";
    hist.zLabel = "This is the Z axis label";
    hist.bins = (float *)bins; 
    hist2DSetHistogram(w, &hist);
    
    /* Realize the top level widget and give control to the X event loop */
    XtRealizeWidget(toplevel);
    XtAppMainLoop(app_context);
}
