Summary:	High-performance CORBA Object Request Broker.
Name:		ORBit2
Version:	2.3.95
Release:	1
Source:		ftp://ftp.labs.redhat.com/pub/ORBit/ORBit-%{version}.tar.gz
Group:		System Environment/Libraries
Copyright:	LGPL/GPL
BuildRoot:	/var/tmp/%{name}-%{version}-root
URL:		http://www.labs.redhat.com/orbit/
Requires:	glib2
Requires:	linc
BuildRequires:  glib2-devel
BuildRequires:  linc-devel

%description
ORBit is a high-performance CORBA (Common Object Request Broker 
Architecture) ORB (object request broker). It allows programs to 
send requests and receive replies from other programs, regardless 
of the locations of the two programs. CORBA is an architecture that 
enables communication between program objects, regardless of the 
programming language they're written in or the operating system they
run on.

You will need to install this package if you want to run programs that use
the ORBit implementation of CORBA technology.

%package devel
Summary: Development libraries, header files and utilities for ORBit2.
Group: Development/Libraries
Requires: indent
Requires: glib2-devel
Requires: linc-devel
Requires: %{name} = %{version}

%description devel
This package contains the header files, libraries and utilities 
necessary to write programs that use CORBA technology. If you want to
write such programs, you'll also need to install the ORBit package.

%prep
%setup -q -n ORBit-%{version}

%build
# Needed for snapshot releases.
#MYCFLAGS="-DG_DISABLE_ASSERT -DG_DISABLE_CHECKS $RPM_OPT_FLAGS"
MYCFLAGS="$RPM_OPT_FLAGS"
if [ ! -f configure ]; then
   CFLAGS="$MYCFLAGS" ./autogen.sh --prefix=%{_prefix} \
	       --bindir=%{_bindir} --mandir=%{_mandir} \
	       --localstatedir=%{_localstatedir} --libdir=%{_libdir} \
	       --datadir=%{_datadir} --includedir=%{_includedir} \
	       --sysconfdir=%{_sysconfdir}  --infodir=%{_infodir}
else
   CFLAGS="$MYCFLAGS" ./configure --prefix=%{_prefix} \
	       --bindir=%{_bindir} --mandir=%{_mandir} \
	       --localstatedir=%{_localstatedir} --libdir=%{_libdir} \
	       --datadir=%{_datadir} --includedir=%{_includedir} \
	       --sysconfdir=%{_sysconfdir} --infodir=%{_infodir}
fi
make

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{_prefix} bindir=$RPM_BUILD_ROOT%{_bindir} \
    mandir=$RPM_BUILD_ROOT%{_mandir} libdir=$RPM_BUILD_ROOT%{_libdir} \
    datadir=$RPM_BUILD_ROOT%{_datadir} \
    includedir=$RPM_BUILD_ROOT%{_includedir} \
    infodir=$RPM_BUILD_ROOT%{_infodir} \
    sysconfdir=$RPM_BUILD_ROOT%{_sysconfdir} install

gzip -9 $RPM_BUILD_ROOT%{_infodir}/*

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post devel
/sbin/install-info %{_infodir}/libIDL.info.gz %{_infodir}/dir

%preun devel
if [ $1 = 0 ]; then
   /sbin/install-info --delete %{_infodir}/libIDL.info.gz %{_infodir}/dir
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)

%doc AUTHORS COPYING ChangeLog NEWS README TODO
%doc -P libIDL/COPYING libIDL/ChangeLog libIDL/AUTHORS
%doc -P libIDL/README* libIDL/NEWS libIDL/BUGS libIDL/tstidl.c

%{_libdir}/lib*.so.*
%{_libdir}/orbit/Everything*.so.*
%{_bindir}/orbit-name-server
%{_bindir}/name-client
%{_bindir}/ior-decode
%{_bindir}/typelib-dump

%files devel
%{_libdir}/lib*.so
%{_libdir}/lib*a
%{_libdir}/orbit/*.so
%{_libdir}/orbit/*a
%{_libdir}/pkgconfig/*.pc
%{_bindir}/orbit-idl
%{_bindir}/libIDL-config
%{_bindir}/orbit-config
%{_includedir}/orbit-idl2.h
%{_includedir}/ORBitservices
%{_includedir}/orbit
%{_includedir}/libIDL
%{_infodir}/libIDL.info*
%{_libdir}/*.sh
%{_datadir}/aclocal/*

%changelog
* Mon Sep 24 2001 Mark McLoughlin <mark@skynet.ie>
- use ORBIT_VERSION instead of VERSION

* Tue Sep 18 2001 Jens Finke <jens@gnome.org>
- Changed package name to ORBit2.
- Updated spec file to match gpp standard.
- Removed all hardcoded paths, use rpm macros instead.
- Added glib2 and linc as required packages.
- Removed docdir statement.

* Mon Aug 30 1999 Elliot Lee <sopwith@redhat.com> 0.4.94-1
- Spec file fixes from RHL 6.0.

* Wed Jun 2 1999  Jose Mercado <jmercado@mit.edu>
- Fixed configure.in so spec.in could be used.

* Mon Nov 23 1998 Pablo Saratxaga <srtxg@chanae.alphanet.ch>

- improved %files section, and added use of %{prefix} and install-info
  (well,... no. The info file has not dir info inside, commented out)
