#!/usr/bin/env python
# -*- Mode: python; encoding: utf-8 -*-
import pygtk
pygtk.require('2.0')

import pango
import gtk
import gnomeprint
import gnomeprint.ui


def do_print(dialog, job):
    pc = gnomeprint.Context(dialog.get_config())
    job.render(pc)
    pc.close()

def print_pango_markup(self, context, markup):
    "Print some markup to the supplied context"
    ## need to use pango.Layout to format paragraphs
    ## for each block of text
    paraContext = gnomeprint.pango_create_context(gnomeprint.pango_get_default_font_map())
    para = pango.Layout(paraContext)
    para.set_markup(markup)
    context.pango_layout(para)

def render_to_job(job):
    pc = job.get_context()
    width, height = gnomeprint.job_get_page_size_from_config(job.get_config())

    ## <<<begin drawing>>>
    pc.beginpage("1")
    pc.setlinewidth(3.0)
    x1 = width*.1
    x2 = width*.9
    y1 = height*.1
    y2 = height*.9
    pc.rect_stroked(x1, y1, x2 - x1, y2 - y1)
    pc.line_stroked(x1, y1, x2, y2)
    pc.line_stroked(x2, y1, x1, y2)

    ## Draw a text paragraph using pango
    paraContext = gnomeprint.pango_create_context(gnomeprint.pango_get_default_font_map())
    para = pango.Layout(paraContext)
    para.set_font_description(pango.FontDescription("Sans 36"))
    para.set_markup("♪ Hello <b>World</b> ♪")
    w, h = para.get_size()
    w /= pango.SCALE
    h /= pango.SCALE
    pc.moveto(width - w, height - h)
    pc.pango_layout(para)

    pc.showpage()
    ## <<<end drawing>>>
    job.close()


def show_preview(dialog):
    job = gnomeprint.Job(dialog.get_config())
    render_to_job(job)
    w = gnomeprint.ui.JobPreview(job, "Print Preview")
    w.set_property('allow-grow', 1)
    w.set_property('allow-shrink', 1)
    w.set_transient_for(dialog)
    w.show_all()


def print_dialog_response(dialog, resp, job):
    if resp == gnomeprint.ui.DIALOG_RESPONSE_PREVIEW:
	show_preview(dialog)
    elif resp == gnomeprint.ui.DIALOG_RESPONSE_CANCEL:
	dialog.destroy()
    elif resp == gnomeprint.ui.DIALOG_RESPONSE_PRINT:
	render_to_job(job)
	do_print(dialog, job)
	dialog.destroy()

def show_print_dialog():
    job = gnomeprint.Job(gnomeprint.config_default())
    dialog = gnomeprint.ui.Dialog(job, "Print...",
				  gnomeprint.ui.DIALOG_RANGE|
				  gnomeprint.ui.DIALOG_COPIES)
    flags = (gnomeprint.ui.RANGE_CURRENT
	     |gnomeprint.ui.RANGE_ALL
	     |gnomeprint.ui.RANGE_RANGE
	     |gnomeprint.ui.RANGE_SELECTION)
    # FIXME: the current and range strings should be translated in a
    # "real" application    
    dialog.construct_range_page(flags, 1, 1, "_Current", "_Range")

    dialog.connect('response', print_dialog_response, job)
    dialog.show()
    return dialog

if __name__ == '__main__':
    dialog = show_print_dialog()
    dialog.connect("destroy", lambda *args: gtk.main_quit())
    gtk.main()

