/**
 * boot.c: Lotus 123 support for Gnumeric
 *
 * Author:
 *    See: README
 *    Michael Meeks <mmeeks@gnu.org>
 **/
#include <stdio.h>
#include <unistd.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <assert.h>
#include <config.h>
#include <stdio.h>
#include <ctype.h>
#include <gnome.h>
#include "gnumeric.h"
#include "workbook-view.h"
#include "workbook.h"
#include "gnumeric-util.h"
#include "main.h"
#include "sheet.h"
#include "file.h"

#include "lotus.h"
#include "lotus-types.h"
#include "plugin.h"
#include "plugin-util.h"

gchar gnumeric_plugin_version[] = GNUMERIC_VERSION;

static FileOpenerId lotus_opener_id;

static gboolean
lotus_probe (const char *filename, gpointer user_data)
{
	const char *ext;
	char magic[4];
	int fd, rcount;

	if (!filename)
		return FALSE;
	ext = g_extension_pointer (filename);
	if (g_strcasecmp ("wk1", ext) != 0 &&
	    g_strcasecmp ("wks", ext) != 0)
		return FALSE;

	/* Filename is valid.  Now test file.  */
	fd = open (filename, O_RDONLY);
	if (fd < 0) return FALSE;
	rcount = read (fd, magic, 4);
	close (fd);

	if (rcount != 4) return FALSE;

	if (magic[0] == (LOTUS_BOF & 0xff) &&
	    magic[1] == ((LOTUS_BOF >> 8) & 0xff) &&
	    magic[2] == (2 & 0xff) &&
	    magic[3] == ((2 >> 8) & 0xff))
		return TRUE;

	return FALSE;
}


static int
lotus_load (IOContext *context, WorkbookView *wb_view,
            const char *filename, gpointer user_data)
{
	Workbook *wb = wb_view_workbook (wb_view);
	int ret;

	ret = lotus_read (context, wb, filename);

	if (ret == 0)
		workbook_set_saveinfo (wb, filename, FILE_FL_MANUAL_REMEMBER,
				       FILE_SAVER_ID_INVALID);

	return ret;
}

gboolean
can_deactivate_plugin (PluginInfo *pinfo)
{
	return TRUE;
}

gboolean
cleanup_plugin (PluginInfo *pinfo)
{
	file_format_unregister_open (lotus_opener_id);
	return TRUE;
}

gboolean
init_plugin (PluginInfo *pinfo, ErrorInfo **ret_error)
{
	lotus_opener_id = file_format_register_open (
	                  50, _("Lotus file format (*.wk1)"),
	                  &lotus_probe, &lotus_load, NULL);

	return TRUE;
}
