/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "gtk_java.h"
#include "jg_jnu.h"
#include <libebook/e-contact.h>
#include "org_gnu_libebook_EContactDate.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org_gnu_libebook_EContactDate
 * Method:    e_contact_date_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactDate_e_1contact_1date_1new
(JNIEnv *env, jclass cls)
{
    return getStructHandle(env, e_contact_date_new(), NULL, (JGFreeFunc)e_contact_date_free);
}

/*
 * Class:     org_gnu_libebook_EContactDate
 * Method:    e_contact_date_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactDate_e_1contact_1date_1from_1string
(JNIEnv *env, jclass cls, jstring value)
{
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    EContactDate *date = e_contact_date_from_string(value_g);
    (*env)->ReleaseStringUTFChars(env, value, value_g);
    return getStructHandle(env, date, NULL, (JGFreeFunc)e_contact_date_free);
}


/*
 * Class:     org_gnu_libebook_EContactDate
 * Method:    e_contact_date_get_month
 */
JNIEXPORT jint JNICALL Java_org_gnu_libebook_EContactDate_e_1contact_1date_1get_1month
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactDate *contact_date = (EContactDate*)getPointerFromHandle(env, obj);
    return (jint)contact_date->month;
}

/*
 * Class:     org_gnu_libebook_EContactDate
 * Method:    e_contact_date_set_month
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactDate_e_1contact_1date_1set_1month
(JNIEnv *env, jclass cls, jobject obj, jint value)
{
    EContactDate *contact_date = (EContactDate*)getPointerFromHandle(env, obj);
    contact_date->month = (int)value;
}

/*
 * Class:     org_gnu_libebook_EContactDate
 * Method:    e_contact_date_get_day
 */
JNIEXPORT jint JNICALL Java_org_gnu_libebook_EContactDate_e_1contact_1date_1get_1day
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactDate *contact_date = (EContactDate*)getPointerFromHandle(env, obj);
    return (jint)contact_date->day;
}

/*
 * Class:     org_gnu_libebook_EContactDate
 * Method:    e_contact_date_set_day
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactDate_e_1contact_1date_1set_1day
(JNIEnv *env, jclass cls, jobject obj, jint value)
{
    EContactDate *contact_date = (EContactDate*)getPointerFromHandle(env, obj);
    contact_date->day = (int)value;
}

/*
 * Class:     org_gnu_libebook_EContactDate
 * Method:    e_contact_date_get_year
 */
JNIEXPORT jint JNICALL Java_org_gnu_libebook_EContactDate_e_1contact_1date_1get_1year
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactDate *contact_date = (EContactDate*)getPointerFromHandle(env, obj);
    return (jint)contact_date->year;
}

/*
 * Class:     org_gnu_libebook_EContactDate
 * Method:    e_contact_date_set_year
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactDate_e_1contact_1date_1set_1year
(JNIEnv *env, jclass cls, jobject obj, jint value)
{
    EContactDate *contact_date = (EContactDate*)getPointerFromHandle(env, obj);
    contact_date->year = (int)value;
}


#ifdef __cplusplus
}

#endif
