/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 07:27:56 EDT
 */

package org.gnu.gnome;
import org.gnu.gdk.Pixbuf;
import org.gnu.glib.Type;
/**
 * The About widget dialog window is designed to pop up from the
 * About button on an application menu. Its purpose is to standardize
 * the form and content.
 */
public class About extends org.gnu.gtk.Dialog {

	/**
	 * Present so that org.gnu.gtk.Dialog() constructor is not called.
	 */
	private About() {
	}

	protected void noopInit() {
	}

	/**
	 * Constructor to create a new About dialog.
	 * @param title The title of the application.
	 * @param version The version of the application.
	 * @param license The license.
	 * @param comments Miscellaneous comments about the application.
	 * @param authors The author(s) of the application.
	 * @param decumenters The documents(s) of the application.
	 * @param translator The translator.
	 * @param pixbuf A pixmap to display on the about dialiag.
	 */
	public About(String title, String version, String license, String comments, String authors[], String documenters[], String translator, Pixbuf pixbuf) {
		int pixbufHandle;
		if (pixbuf == null) {
			pixbufHandle = 0;
		} else {
			pixbufHandle = pixbuf.getHandle();
		}
		handle =
			gnome_about_new(
				title,
				version,
				license,
				comments,
				authors,
				documenters,
				translator,
				pixbufHandle);
		initializeEventHandlers();
	}

	/**
	 * Construct an About box using a handle to a native resource.
	 */
        public About(int handle) {
	    super(handle);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_about_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gnome_about_get_type();
	native static final protected int gnome_about_new(
		String title,
		String version,
		String copyright,
		String comments,
		String [] authors,
		String [] documenters,
		String translatorCredits,
		int logo);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
