/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
	
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_SelectionData_gtk_1selection_1data_1get_1text(JNIEnv 
        *env, jclass cls, jint sel) 
    {
                guchar *txt;
		jstring retval;
		printf( "1");
		txt = gtk_selection_data_get_text ( (GtkSelectionData *) sel);
		printf( "1");
		printf( "1");
		if (txt != NULL){
		printf( "2");
			retval = (*env)->NewStringUTF( env, txt );
		printf( "2");
			g_free(txt);
		printf( "2");
		}else
			retval = (*env)->NewStringUTF( env, "" );
		printf( "1");
		return retval;
    }
	
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_SelectionData_gtk_1selection_1data_1set_1text(JNIEnv 
        *env, jclass cls, jint sel, jstring text) 
    {
		const gchar * text_g = (*env)->GetStringUTFChars(env, text, NULL);
		jboolean retval =  (jboolean) gtk_selection_data_set_text( (GtkSelectionData *) sel, text_g, -1 );
		(*env)->ReleaseStringUTFChars( env, text, text_g );
		return retval;
	}

		
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_SelectionData_getLength(JNIEnv 
        *env, jclass cls, jint sel) 
    {
		GtkSelectionData *sel_g = (GtkSelectionData *) sel;
		return (jint) sel_g->length;
	}

#ifdef __cplusplus
}

#endif
