/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.glib.EventType;

/**
 * An event generated when a column header in a {@link org.gnu.gtk.TreeView} widget has been clicked.
 */
public class TreeViewColumnEvent extends GtkEvent {

	public static class Type extends EventType{
		private Type(int id, String name){
			super(id, name);
		}

		/**
		 * This event indicates that the column header has been clicked.
		 */
		public static final Type CLICKED = new Type(1, "CLICKED");
	}

	/**
	 * Creates a new selection Event. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public TreeViewColumnEvent(Object source) {
		super(source, Type.CLICKED);
	}
}
