import org.gnu.gtk.CellRenderer;
import org.gnu.gtk.CellRendererText;
import org.gnu.gtk.CellRendererToggle;
import org.gnu.gtk.DataColumn;
import org.gnu.gtk.DataColumnBoolean;
import org.gnu.gtk.DataColumnInt;
import org.gnu.gtk.DataColumnString;
import org.gnu.gtk.Gtk;
import org.gnu.gtk.ListStore;
import org.gnu.gtk.SortType;
import org.gnu.gtk.TreeIter;
import org.gnu.gtk.TreeIterComparison;
import org.gnu.gtk.TreeModel;
import org.gnu.gtk.TreeStore;
import org.gnu.gtk.TreeView;
import org.gnu.gtk.TreeViewColumn;
import org.gnu.gtk.Window;
import org.gnu.gtk.WindowType;
import org.gnu.gtk.event.LifeCycleEvent;
import org.gnu.gtk.event.LifeCycleListener;
import org.gnu.gtk.event.TreeViewColumnEvent;
import org.gnu.gtk.event.TreeViewColumnListener;

public class TestTree {

    public static final Object[][] DATA = {
        { "Pro",      new Integer(111), Boolean.TRUE,  "2004-05-12" },
        { "Amateur",  new Integer(111), Boolean.FALSE, "2004-05-11" },
        { "Beginner", new Integer(111), Boolean.TRUE,  "2004-05-10" },
        { "Pro",      new Integer(222), Boolean.FALSE, "2004-05-09" },
        { "Amateur",  new Integer(222), Boolean.TRUE,  "2004-05-08" },
        { "Beginner", new Integer(222), Boolean.FALSE, "2004-05-07" },
        { "Null!",    new Integer(333), Boolean.TRUE,  "2004-05-06" }
    };

    private ListStore store;
    private DataColumnString dataString;
    private DataColumnInt dataInt;
    private DataColumnBoolean dataBool;
    private DataColumnString dataString2;
	
    public static void main( String[] argv ) {
        Gtk.init( argv );
	TestTree tt = new TestTree();
        Gtk.main();
    }

    public TestTree() {
        Window window = new Window( WindowType.TOPLEVEL );
	window.setTitle( "Test Tree" );
	window.addListener( new Life() );

	// Make some data blocks to refer to the data for the tree
        dataString = new DataColumnString();
        dataInt = new DataColumnInt();
        dataBool = new DataColumnBoolean();
        dataString2 = new DataColumnString();

	// Construct a new store for the data of the tree.
        store = new ListStore( new DataColumn[] { dataString, 
                                                  dataInt, 
                                                  dataBool, 
                                                  dataString2 } );
        addData( DATA );

	// Construct the widget, using the above defined store.
	TreeView treeWidget = new TreeView( store );
        treeWidget.setAlternateRowColor( true );

        // Create the SMS Type column.
	TreeViewColumn column = new TreeViewColumn();
	column.setTitle( "Type" );
	column.setResizable(true);
	column.setReorderable(true);
	column.setClickable(true);
	treeWidget.appendColumn( column );
	CellRenderer renderer = new CellRendererText();
	column.packStart( renderer, true );
	column.addAttributeMapping( renderer, 
                                    CellRendererText.Attribute.TEXT, 
                                    dataString );
        column.addListener( new SortedColumnListener( dataString ) );
        store.setSortMethod( new TypeColumn(), dataString );

        // Create the Number column.
        column = new TreeViewColumn();
	column.setTitle( "Number" );
	column.setResizable(true);
	column.setReorderable(true);
	column.setClickable(true);
	treeWidget.appendColumn( column );
        renderer = new CellRendererText();
	column.packStart( renderer, true );
	column.addAttributeMapping( renderer, 
                                    CellRendererText.Attribute.TEXT, 
                                    dataInt );
        column.addListener( new SortedColumnListener( dataInt ) );
        store.setSortMethod( new NumberColumn(), dataInt );

        // Create the Boolean column.
        column = new TreeViewColumn();
	column.setTitle( "Boolean" );
	column.setResizable(true);
	column.setReorderable(true);
	column.setClickable(true);
	treeWidget.appendColumn( column );
        renderer = new CellRendererToggle();
	column.packStart( renderer, true );
	column.addAttributeMapping( renderer, 
                                    CellRendererToggle.Attribute.ACTIVE, 
                                    dataBool );

        // Create the Timestamp column.
        column = new TreeViewColumn();
	column.setTitle( "Date" );
	column.setResizable(true);
	column.setReorderable(true);
	column.setClickable(true);
	treeWidget.appendColumn( column );
        renderer = new CellRendererText();
	column.packStart( renderer, true );
	column.addAttributeMapping( renderer, 
                                    CellRendererText.Attribute.TEXT, 
                                    dataString2 );
        column.addListener( new SortedColumnListener( dataString2 ) );
        store.setSortMethod( new TimestampColumn(), dataString2 );

	window.add( treeWidget );
	treeWidget.show();
        window.show();
    }

    protected void addData( Object[][] data ) {
        Object[] row = null;
        TreeIter iter = null;

        for (int i = 0; i < data.length; i++) {
            iter = store.appendRow();
            row = data[i];
            store.setValue( iter, dataString, (String)row[0] );
            store.setValue( iter, dataInt, (int)((Integer)row[1]).intValue() );
            store.setValue( iter, dataBool, ((Boolean)row[2]).booleanValue() );
            store.setValue( iter, dataString2, (String)row[3] );
        }
    }

    protected class SortedColumnListener implements TreeViewColumnListener {
        private DataColumn column;
        public SortedColumnListener( DataColumn column ) {
            this.column = column;
        }
        public void columnClickedEvent( TreeViewColumnEvent event ) {
            SortType type = SortType.ASCENDING;
            if ( store.getSortColumnId() == column.getColumn() ) {
                if ( store.getSortOrder().equals( SortType.ASCENDING ) ) {
                    type = SortType.DESCENDING;
                } else {
                    type = SortType.ASCENDING;
                }
            }
            store.setSortColumn( column, type );
        }
    }

    protected class TypeColumn implements TreeIterComparison {
        public int compareTreeIters( TreeModel store, 
                                     TreeIter a, TreeIter b ) {
            String as = store.getValue( a, dataString );
            String bs = store.getValue( b, dataString );
            return as.compareTo( bs );
        }
    }

    protected class NumberColumn implements TreeIterComparison {
        public int compareTreeIters( TreeModel store, 
                                     TreeIter a, TreeIter b ) {
            Integer as = new Integer( store.getValue( a, dataInt ) );
            Integer bs = new Integer( store.getValue( b, dataInt ) );
            return as.compareTo( bs );
        }
    }

    protected class TimestampColumn implements TreeIterComparison {
        public int compareTreeIters( TreeModel store, 
                                     TreeIter a, TreeIter b ) {
            String as = store.getValue( a, dataString2 );
            String bs = store.getValue( b, dataString2 );
            return as.compareTo( bs );
        }
    }

    protected class Life implements LifeCycleListener {
        public void lifeCycleEvent(LifeCycleEvent event) {}
        public boolean lifeCycleQuery(LifeCycleEvent event) {
            if (event.isOfType(LifeCycleEvent.Type.DESTROY) || 
                event.isOfType(LifeCycleEvent.Type.DELETE)) {
                Gtk.mainQuit();
            }
            return false;
        }
    }
}
