/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

 /*
 
  * TODO:
  * - Wrap the intern native methode.
  * - Beautify documentation.
  */
 
package org.gnu.gdk;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

public class Atom extends Boxed 
{
	
	public Atom(String name, boolean onlyIfExists) {
		handle = gdk_atom_intern(name, onlyIfExists);
	}
	
	/** 
	 *	Builds an atom with
	 *	the specified handle.
	 */	 
	public Atom(Handle handle){
		this.handle=handle;
	}
	
	/**
	 * Obtains the atom's name.
	 *	@return The atom's name
	 */
	
	public String getName(){
		return Atom.gdk_atom_name(handle);
	}
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected Handle gdk_atom_intern (String atomName, boolean onlyIfExists);
    native static final protected String gdk_atom_name (Handle atom);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

