#ifndef line
static char *RCSid = "$Header$";
#endif
/*
 * trimlog - trim log files
 *
 * David A. Curry
 * SRI International
 * 333 Ravenswood Avenue
 * Menlo Park, CA 94025
 * davy@itstd.sri.com
 *
 * $Log$
 */
#include <syslog.h>
#include <stdio.h>
#include "trimlog.h"

char	*pname;				/* program name (see util.c)	*/

main(argc, argv)
char **argv;
int argc;
{
	TrimCommand *trimcmds, *tc;
	TrimCommand *ReadConfigFile();

	pname = *argv;

	if (!isatty(2))
		openlog(pname, LOG_PID, LOG_DAEMON);

	/*
	 * Raise our resource limits so we can do anything.
	 */
	RaiseLimits();

	/*
	 * Read the configuration file.
	 */
	trimcmds = ReadConfigFile();

	/*
	 * Process the commands we found in the
	 * config file.
	 */
	for (tc = trimcmds; tc != NULL; tc = tc->t_next) {
		switch (tc->t_mode) {
		case SENDSIG:
			SendSig(tc->t_filename, tc->t_parameter);
			break;
		case TRUNCATE:
			Truncate(tc->t_filename, tc->t_parameter);
			break;
		case TRIMBYLINES:
			TrimByLines(tc->t_filename, tc->t_parameter);
			break;
		case TRIMBYBYTES:
			TrimByBytes(tc->t_filename, tc->t_parameter);
			break;
		default:
			Error("unknown trimming mode: %d\n", tc->t_mode, 0);
			break;
		}
	}

	exit(0);
}
