#ifndef lint
static char *RCSid = "$Header$";
#endif
/*
 * truncate.c - the "truncate" command for "trimlog"
 *
 * David A. Curry
 * SRI International
 * 333 Ravenswood Avenue
 * Menlo Park, CA 94025
 * davy@itstd.sri.com
 *
 * $Log$
 */
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <unistd.h>
#include <stdio.h>

/*
 * Truncate - truncate a file so that it's no more than bytes bytes long.
 *	      This lops off the end of the file, saving the first bytes
 *	      bytes.  TrimByBytes saves the last bytes bytes.
 */
Truncate(file, bytes)
char *file;
int bytes;
{
	int fd;
	struct stat st;

	if (access(file, F_OK) < 0)
		return;

	/*
	 * Open the file for writing.
	 */
	if ((fd = open(file, O_WRONLY)) < 0) {
		Perror(file, "open");
		return;
	}

	/*
	 * Check the current file size.
	 */
	if (fstat(fd, &st) < 0) {
		Perror(file, "fstat");
		close(fd);
		return;
	}

	/*
	 * If it's already less than bytes bytes,
	 * we don't need to do anything.
	 */
	if (st.st_size <= bytes) {
		close(fd);
		return;
	}

	/*
	 * Truncate the file.
	 */
	if (ftruncate(fd, bytes) < 0)
		Perror(file, "ftruncate");

	/*
	 * Close the file.
	 */
	close(fd);
}
