/* -*- mode: C; c-basic-offset: 4 -*- */

#include <Python.h>

#include <libgnomevfs/gnome-vfs-init.h>
#include <libgnomevfs/gnome-vfs-uri.h>
#include <libgnomevfs/gnome-vfs-file-info.h>
#include <libgnomevfs/gnome-vfs-directory.h>
#include <libgnomevfs/gnome-vfs-ops.h>

G_BEGIN_DECLS

/* vfsmodule.c */

gboolean pygnome_vfs_result_check(GnomeVFSResult result);


/* vfs-uri.c */

typedef struct {
    PyObject_HEAD
    GnomeVFSURI *uri;
} PyGnomeVFSURI;
extern PyTypeObject PyGnomeVFSURI_Type;

#define pygnome_vfs_uri_get(v) (((PyGnomeVFSURI *)(v))->uri)
/* takes ownership of URI */
PyObject *pygnome_vfs_uri_new(GnomeVFSURI *uri);


/* vfs-file-info.c */

typedef struct {
    PyObject_HEAD
    GnomeVFSFileInfo *finfo;
} PyGnomeVFSFileInfo;
extern PyTypeObject PyGnomeVFSFileInfo_Type;

#define pygnome_vfs_file_info_get(v) (((PyGnomeVFSFileInfo *)(v))->finfo)
PyObject *pygnome_vfs_file_info_new(GnomeVFSFileInfo *finfo);


/* vfs-dir-handle.c */

typedef struct {
    PyObject_HEAD
    GnomeVFSDirectoryHandle *dir;
} PyGnomeVFSDirectoryHandle;
extern PyTypeObject PyGnomeVFSDirectoryHandle_Type;

#define pygnome_vfs_directory_handle_get(v) (((PyGnomeVFSDirectoryHandle *)(v))->dir)
PyObject *pygnome_vfs_directory_handle_new(GnomeVFSDirectoryHandle *dir);


/* vfs-handle.c */

typedef struct {
    PyObject_HEAD
    GnomeVFSHandle *fd;
} PyGnomeVFSHandle;
extern PyTypeObject PyGnomeVFSHandle_Type;

#define pygnome_vfs_handle_get(v) (((PyGnomeVFSHandle *)(v))->fd)
PyObject *pygnome_vfs_handle_new(GnomeVFSHandle *fd);

G_END_DECLS
