/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtk;

/**
 */
public class ToggleAction extends Action {

	public ToggleAction(String name, String label, String tooltip, String stockId) {
		super(gtk_toggle_action_new(name, label, tooltip, stockId));
	}
	
	public ToggleAction(int handle) {
		super(handle);
	}

	public void setActive(boolean active) {
		gtk_toggle_action_set_active(getHandle(), active);
	}
	
	public boolean getActive() {
		return gtk_toggle_action_get_active(getHandle());
	}
	
	public void setDrawAsRadio(boolean drawAsRadio) {
		gtk_toggle_action_set_draw_as_radio(getHandle(), drawAsRadio);
	}
	
	public boolean getDrawAsRadio() {
		return gtk_toggle_action_get_draw_as_radio(getHandle());
	}
	
	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_toggle_action_get_type ();
	native static final protected int gtk_toggle_action_new(String name, String label, String tooltip, String stockId);
	native static final protected void gtk_toggle_action_toggled(int action);
	native static final protected void gtk_toggle_action_set_active(int action, boolean isActive);
	native static final protected boolean gtk_toggle_action_get_active(int action);
	native static final protected void gtk_toggle_action_set_draw_as_radio(int action, boolean radio);
	native static final protected boolean gtk_toggle_action_get_draw_as_radio(int action);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
