/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

 /*
  * TODO:
  * Documentation.
  * add functionallity like in awt?
  */

package org.gnu.gdk;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

/**
 * Represents a point with x and y coordinates.
 */
public class Point extends Boxed 
{
	/**
     * Construct a Point providing the x and y coordinates.
     * @param x
     * @param y
	 */
    public Point(int x, int y) {
		super(gdk_point_new());
		setX(x);
		setY(y);
	}
	
	public Point(Handle handle){
		this.handle=handle;
	}
	
    /**
     * Retrieve the x coordinate for the Point.
     * @return
     */
	public int getX(){
		return Point.getX(handle);
	}
	
    /**
     * Set the x coordinate for the Point.
     * @param x
     */
	public void setX(int x){
		setX(handle,x);
	}
	
    /**
     * Retrieve the y coordinate for the Point.
     * @return
     */
	public int getY(){
		return Point.getY(handle);
	}
	
    /**
     * Set the y coordinate for the Point.
     * @param y
     */
	public void setY(int y){
		setY(handle,y);
	}
	
	protected void finalize() throws Throwable {
		gdk_point_free(handle);
	}
	
	
	
    native static final protected int getX (Handle obj);
    native final protected void setX (Handle obj, int x);
    native static final protected int getY (Handle obj);
    native final protected void setY (Handle obj, int y);
	native static final protected Handle gdk_point_new();
	native static final protected void gdk_point_free(Handle handle);
}

