/*
 * Java-Gnome Bindings Library
 *
 * Copyright 2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.glib;

/**
 * Interface used as a callback for property notification events
 * ("notify" signal). The notify signal is emitted on an object when
 * one of its properties has been changed. Note that getting this
 * signal doesn't guarantee that the value of the property has
 * actually changed, it may also be emitted when the setter for the
 * property is called to reinstate the previous value.
 */
public interface PropertyNotificationListener {

    /**
     * Handle a property notification event.
     *
     * @param obj The object which received the signal.
     * @param property The name of the property which changed.
     */
    public void notify( GObject obj, String property );
}
