--
-- This file is part of TALER
-- Copyright (C) 2024 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE TABLE donation_units
  (donation_unit_serial BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE
  ,h_donation_unit_pub BYTEA PRIMARY KEY CHECK (LENGTH(h_donation_unit_pub)=64)
  ,donation_unit_pub BYTEA UNIQUE NOT NULL
  ,validity_year INT8 NOT NULL
  ,value taler_amount NOT NULL
  );
COMMENT ON TABLE donation_units
  IS 'Main donation_unit table. All the valid donation units the Donau knows about.';
COMMENT ON COLUMN donation_units.h_donation_unit_pub
  IS 'Hash value of the donation unit public key.';
COMMENT ON COLUMN donation_units.validity_year
  IS 'The year, for which the donation unit is valid.';
COMMENT ON COLUMN donation_units.value
  IS 'The amount and currency that this donation unit represents.';
