/******************************************************************************
 JBooleanIO.cc

	Stream operators and utilities for JBoolean type.

	Copyright  1994 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <jTypes.h>
#include <jStreamUtil.h>
#include <jAssert.h>

const JCharacter kTrueMarker  = 'T';
const JCharacter kFalseMarker = 'F';

istream&
operator>>
	(
	istream&	input,
	JBoolean&	jbool
	)
{
	input >> ws;

	char temp;
	input.get(temp);

	if (temp == kTrueMarker)
		{
		jbool = kTrue;
		}
	else if (temp == kFalseMarker)
		{
		jbool = kFalse;
		}
	else
		{
		input.putback(temp);
		JSetState(input, ios::failbit);
		}

	return input;
}

ostream&
operator<<
	(
	ostream&		output,
	const JBoolean	jbool
	)
{
	if (jbool == kTrue)
		{
		output.put(kTrueMarker);
		}
	else if (jbool == kFalse)
		{
		output.put(kFalseMarker);
		}
	else
		{
		assert( 0 );	// no other possible values for JBoolean
		}

	return output;
}
