/******************************************************************************
 JDynamicHistogram.h

	Interface for JDynamicHistogram class.

	Copyright  1995 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JDynamicHistogram
#define _H_JDynamicHistogram

#include <JHistogram.h>

template <class T>
class JDynamicHistogram : public JHistogram<T>
{
public:

	JDynamicHistogram(const JSize binCount = 0);
	JDynamicHistogram(const JDynamicHistogram<T>& source);

	virtual ~JDynamicHistogram();

	const JDynamicHistogram<T>& operator=(const JDynamicHistogram<T>& source);

	void	InsertBin(const JBinIndex index);
	void	PrependBin();
	void	AppendBin();
	void	RemoveBin(const JBinIndex index);
	void	RemoveAllBins();
	void	MoveBinToIndex(const JBinIndex currentIndex, const JBinIndex newIndex);
};

#endif
