/******************************************************************************
 JError.h

	Base class for all errors

	Copyright  1997 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JError
#define _H_JError

#include <JBroadcaster.h>

class JString;

extern const JCharacter* kJNoError;
extern const JCharacter* kJUnknownError;
extern const JCharacter* kJUnexpectedError;

extern const JCharacter* kJNoErrorMsg;

class JError : public JBroadcaster::Message
{
public:

	JError(const JError& source);

	virtual	~JError();

	const JError& operator=(const JError& source);

	const JCharacter*	GetMessage() const;
	void				ReportError() const;

	JBoolean
	OK() const
	{
		return Is(kJNoError);
	}

protected:

	JError(const JCharacter* type, const JCharacter* msg,
		   const JBoolean copyMsg = kFalse);

	void	SetMessage(const JCharacter* msg, const JBoolean copyMsg);

private:

	// exactly one of the following is not NULL

	const JCharacter*	itsSMessage;
	JString*			itsDMessage;
};

/******************************************************************************
 Derived classes

 ******************************************************************************/

class JNoError : public JError
{
public:

	JNoError()
		:
		JError(kJNoError, kJNoErrorMsg)
		{ };
};

class JUnknownError : public JError
{
public:

	JUnknownError(const int err);
};

class JUnexpectedError : public JError
{
public:

	JUnexpectedError(const int err);
};

#endif
