/******************************************************************************
 JInPipeStream.h

	Interface for the JInPipeStream class

	Copyright  1998 by John Lindal. All rights reserved.

 *****************************************************************************/

#ifndef _H_JInPipeStream
#define _H_JInPipeStream

#include <stdiostream.h>
#include <jTypes.h>

class JInPipeStream : public istream
{
public:

	JInPipeStream(const int fd, const JBoolean close);

	virtual ~JInPipeStream();

	void	close();

	JBoolean	WillClosePipe() const;
	void		ShouldClosePipe(const JBoolean close = kTrue);

private:

	stdiobuf	itsBuffer;
	const int	itsDescriptor;
	JBoolean	itsCloseFlag;	// kTrue => close when we are destructed

private:

	// not allowed

	JInPipeStream(const JInPipeStream& source);
	const JInPipeStream& operator=(const JInPipeStream& source);
};


/******************************************************************************
 Closing the underlying pipe

 *****************************************************************************/

inline JBoolean
JInPipeStream::WillClosePipe()
	const
{
	return itsCloseFlag;
}

inline void
JInPipeStream::ShouldClosePipe
	(
	const JBoolean close
	)
{
	itsCloseFlag = close;
}

#endif
