/******************************************************************************
 JPtrArrayIterator.h

	Interface for JPtrArray Iterator class template

	Copyright  1994-97 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JPtrArrayIterator
#define _H_JPtrArrayIterator

#include <JOrderedSetIterator.h>

// must forward declare to avoid #include loop
// (We do it here so JPtrArray includes JPtrArrayIterator for convenience.)
template <class T> class JPtrArray;

template <class T>
class JPtrArrayIterator : public JOrderedSetIterator<T*>
{
public:

	JPtrArrayIterator(const JPtrArray<T>& theArray,
					  const JIteratorPosition start = kJIteratorStartAtBeginning,
					  const JIndex index = 0);
	JPtrArrayIterator(JPtrArray<T>* theArray,
					  const JIteratorPosition start = kJIteratorStartAtBeginning,
					  const JIndex index = 0);

	// only allowed if constructed from non-const JOrderedSet<T>*

	virtual JBoolean	DeletePrev();
	virtual JBoolean	DeleteNext();
};

#endif
