/******************************************************************************
 jCommandLine.cc

	Routines useful in a command line interface.

	Copyright  1994-99 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <jCommandLine.h>
#include <iostream.h>
#include <stdlib.h>
#include <jAssert.h>

/******************************************************************************
 JWaitForReturn

 ******************************************************************************/

void
JWaitForReturn()
{
	cout << endl << "Press return to continue...";

	cin.clear();
	while (cin.get() != '\n') { };

	cout << endl;
}

/******************************************************************************
 JInputFinished

	When you are done getting information from the user, call this to
	remove the last return typed by the user.

	This insures that JWaitForReturn will work the first time.

 ******************************************************************************/

void
JInputFinished()
{
	cin.clear();
	cin.get();
}

/******************************************************************************
 JCheckForValues

	Useful when parsing command line options.  Prints msg and exits if there
	are fewer than valueCount arguments left.

 ******************************************************************************/

void
JCheckForValues
	(
	const JSize			valueCount,
	const JIndex		index,
	const JSize			argc,
	char*				argv[],
	const JCharacter*	msg
	)
{
	if (index >= argc - valueCount + 1)
		{
		cerr << argv[0] << ": " << msg << endl;
		exit(1);
		}
}
