/******************************************************************************
 jGlobals.h

	Copyright  1997 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_jGlobals
#define _H_jGlobals

// we include these for convenience

#include <JAssertBase.h>
#include <JUserNotification.h>
#include <JChooseSaveFile.h>
#include <JCreateProgressDisplay.h>

class JGetCurrentFontManager;
class JFontManager;
class JGetCurrentColormap;
class JColormap;

void JInitCore(JAssertBase* ah = NULL, JUserNotification* un = NULL,
			   JChooseSaveFile* csf = NULL, JCreateProgressDisplay* cpg = NULL,
			   JGetCurrentFontManager* gcfm = NULL,
			   JGetCurrentColormap* gcc = NULL,
			   const JCharacter* defaultFontName = NULL,
			   const JCharacter* greekFontName = NULL,
			   const JCharacter* monospaceFontName = NULL);

void JDeleteGlobals();

JBoolean				JGetAssertHandler(JAssertBase** ah);

JUserNotification*		JGetUserNotification();
JChooseSaveFile*		JGetChooseSaveFile();
JCreateProgressDisplay*	JGetCreatePG();

const JFontManager*		JGetCurrFontManager();
JColormap*				JGetCurrColormap();

const JCharacter*		JGetDefaultFontName();
const JCharacter*		JGetGreekFontName();
const JCharacter*		JGetMonospaceFontName();


/******************************************************************************
 JNewPG

	Convenience function.

 ******************************************************************************/

inline JProgressDisplay*
JNewPG()
{
	return (JGetCreatePG())->New();
}

#endif
