/******************************************************************************
 jTime.cc

	Routines to augment time.c

	Copyright  1995 John Lindal. All rights reserved.

 ******************************************************************************/

#include <jTime.h>
#include <JString.h>
#include <jMath.h>
#include <unistd.h>
#include <jMissingProto.h>
#include <jAssert.h>

/******************************************************************************
 JWait

	Waits for the specified number of seconds.

 ******************************************************************************/

void
JWait
	(
	const double delta
	)
{
#if defined __MWERKS__ || defined __VCPP__

	const clock_t startTime = clock();
	const clock_t endTime   = startTime + JRound(delta * CLOCKS_PER_SEC);

	while (clock() < endTime) { };

#elif defined _J_UNIX

	double remaining = delta;
	while (remaining > 10.0)
		{
		usleep(10000000UL);					// 10 seconds
		remaining -= 10.0;
		}
	usleep((unsigned long) JRound(remaining * 1000000));	// remainder

#else

	figure out what to do!

#endif
}

/******************************************************************************
 JGetTimeStamp

	Returns the time stamp from ctime (minus the line feed) as a JString.

 ******************************************************************************/

JString
JGetTimeStamp()
{
	return JConvertToTimeStamp(time(NULL));
}

/******************************************************************************
 JConvertToTimeStamp

	Returns the time stamp from ctime (minus the line feed) as a JString.

 ******************************************************************************/

JString
JConvertToTimeStamp
	(
	const time_t t
	)
{
	JString timeStamp  = ctime(&t);
	const JSize length = timeStamp.GetLength();
	timeStamp.RemoveSubstring(length, length);
	return timeStamp;
}
