/******************************************************************************
 sptest.cc

	A test program for Spencer's regex package.

	Copyright  1997 by Dustin Laurence.  All rights reserved.
	
	Base code generated by Codemill v0.1.0

 *****************************************************************************/

#include <iostream.h>

#include <sys/types.h>
#include <regex.h>

#include <jAssert.h>

/******************************************************************************
 main

 *****************************************************************************/

int
main()
{
	regex_t regex;

	char* pattern = "[[:<:]]";

	if ( regcomp(&regex, pattern, REG_EXTENDED) )
		{
		cout << "   Failed to compile" << endl;
		}

	regmatch_t match;

	char*  string = " abc def ";
	size_t strLen = strlen(string);

	match.rm_so = 0;
	match.rm_eo = strLen;
	while ( !regexec(&regex, string, 1, &match, REG_STARTEND) )
		{
		cout << "Found match (" << match.rm_so << ", " << match.rm_eo << ")" << endl;
		match.rm_so = match.rm_eo + 1;
		match.rm_eo = strLen;
		}

	return 0;
}
