/******************************************************************************
 JXCSFDialogBase.h

	Interface for the JXCSFDialogBase class

	Copyright  1996-99 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXCSFDialogBase
#define _H_JXCSFDialogBase

#include <JXDialogDirector.h>

class JString;
class JUNIXDirInfo;
class JXUNIXDirTable;
class JXWidget;
class JXStaticText;
class JXInputField;
class JXPathInput;
class JXTextButton;
class JXTextCheckbox;
class JXStringHistoryMenu;
class JXPathHistoryMenu;
class JXScrollbarSet;
class JXNewDirButton;
class JXGetNewDirDialog;
class JXIdleTask;

class JXCSFDialogBase : public JXDialogDirector
{
public:

	JXCSFDialogBase(JXDirector* supervisor, JUNIXDirInfo* dirInfo,
					const JCharacter* fileFilter);

	virtual ~JXCSFDialogBase();

	virtual void		Activate();
	virtual JBoolean	Deactivate();

	const JString&	GetPath() const;
	const JString&	GetFilter() const;
	JBoolean		HiddenVisible() const;

	// called by JXChooseSaveFile

	void	ReadBaseSetup(istream& input);
	void	WriteBaseSetup(ostream& output) const;

protected:

	void	SetObjects(JXScrollbarSet* scrollbarSet,
					   JXStaticText* pathLabel, JXPathInput* pathInput,
					   JXPathHistoryMenu* pathHistory,
					   JXStaticText* filterLabel, JXInputField* filterInput,
					   JXStringHistoryMenu* filterHistory,
					   JXTextButton* enterButton,
					   JXTextButton* upButton, JXTextButton* homeButton,
					   JXNewDirButton* newDirButton, JXTextCheckbox* showHiddenCB,
					   const JCharacter* message);

	virtual void	AdjustSizings();	// must call inherited
	virtual void	UpdateDisplay();	// must call inherited

	JUNIXDirInfo*	GetDirInfo() const;
	JXUNIXDirTable*	GetFileBrowser() const;
	JXPathInput*	GetPathInput() const;
	JXInputField*	GetFilterInput() const;
	JXNewDirButton*	GetNewDirButton() const;

	JBoolean	GoToItsPath();
	void		AdjustFilter();

	virtual void	Receive(JBroadcaster* sender, const Message& message);

private:

	JUNIXDirInfo*	itsDirInfo;			// we don't own this
	JString*		itsPrevPath;
	JString*		itsPrevFilterString;
	JBoolean		itsDeactCancelFlag;

	JXUNIXDirTable*			itsFileBrowser;
	JXPathHistoryMenu*		itsPathHistory;
	JXPathInput*			itsPathInput;
	JXStringHistoryMenu*	itsFilterHistory;
	JXInputField*			itsFilterInput;
	JXTextButton*			itsEnterButton;
	JXTextButton*			itsUpButton;
	JXTextButton*			itsHomeButton;
	JXNewDirButton*			itsNewDirButton;	// can be NULL
	JXTextCheckbox*			itsShowHiddenCB;

	JXGetNewDirDialog*	itsNewDirDialog;

private:

	void	DisplayMessage(const JCharacter* message, JXScrollbarSet* scrollbarSet,
						   JXStaticText* pathLabel, JXPathHistoryMenu* pathHistory,
						   JXStaticText* filterLabel, JXStringHistoryMenu* filterHistory);

	void	GetNewDirectory();
	void	CreateNewDirectory();

	void	SelectPrevDirectory();

	// not allowed

	JXCSFDialogBase(const JXCSFDialogBase& source);
	const JXCSFDialogBase& operator=(const JXCSFDialogBase& source);
};


/******************************************************************************
 Access to objects (protected)

 ******************************************************************************/

inline JUNIXDirInfo*
JXCSFDialogBase::GetDirInfo()
	const
{
	return itsDirInfo;
}

inline JXUNIXDirTable*
JXCSFDialogBase::GetFileBrowser()
	const
{
	return itsFileBrowser;
}

inline JXPathInput*
JXCSFDialogBase::GetPathInput()
	const
{
	return itsPathInput;
}

inline JXInputField*
JXCSFDialogBase::GetFilterInput()
	const
{
	return itsFilterInput;
}

inline JXNewDirButton*
JXCSFDialogBase::GetNewDirButton()
	const
{
	return itsNewDirButton;
}

#endif
