/******************************************************************************
 JXEditHelpPrefsDialog.h

	Interface for the JXEditHelpPrefsDialog class

	Copyright  1998 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXEditHelpPrefsDialog
#define _H_JXEditHelpPrefsDialog

#include <JXDialogDirector.h>

class JString;
class JXInputField;

class JXEditHelpPrefsDialog : public JXDialogDirector
{
public:

	JXEditHelpPrefsDialog(JXDirector* supervisor,
						  const JCharacter* viewURLCmd,
						  const JCharacter* sendMailCmd);

	virtual ~JXEditHelpPrefsDialog();

	void	GetPrefs(JString* viewURLCmd, JString* sendMailCmd) const;

private:

// begin JXLayout

    JXInputField* itsViewURLCmdInput;
    JXInputField* itsSendMailCmdInput;

// end JXLayout

private:

	void	BuildWindow(const JCharacter* viewURLCmd,
						const JCharacter* sendMailCmd);

	// not allowed

	JXEditHelpPrefsDialog(const JXEditHelpPrefsDialog& source);
	const JXEditHelpPrefsDialog& operator=(const JXEditHelpPrefsDialog& source);
};

#endif
