/******************************************************************************
 JXFileInput.h

	Copyright  1999 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXFileInput
#define _H_JXFileInput

#include <JXInputField.h>

class JXFileInput : public JXInputField
{
public:

	JXFileInput(JXContainer* enclosure,
				const HSizingOption hSizing, const VSizingOption vSizing,
				const JCoordinate x, const JCoordinate y,
				const JCoordinate w, const JCoordinate h);

	virtual ~JXFileInput();

	virtual JBoolean	InputValid();
	JBoolean			GetFile(JString* fullName) const;
	JString				GetTextForChooseFile() const;

	const JString&	GetBasePath() const;
	void			SetBasePath(const JCharacter* path);
	void			ClearBasePath();

	JBoolean	WillAllowInvalidFile() const;
	void		ShouldAllowInvalidFile(const JBoolean allow = kTrue);

	JBoolean	WillRequireReadable() const;
	void		ShouldRequireReadable(const JBoolean require = kTrue);

	JBoolean	WillRequireWritable() const;
	void		ShouldRequireWritable(const JBoolean require = kTrue);

	JBoolean	WillRequireExecutable() const;
	void		ShouldRequireExecutable(const JBoolean require = kTrue);

	static JColorIndex	GetTextColor(const JCharacter* fileName, const JCharacter* basePath,
									 const JBoolean requireRead, const JBoolean requireWrite,
									 const JBoolean requireExec, const JColormap* colormap);

protected:

	virtual void	HandleUnfocusEvent();
	virtual void	ApertureResized(const JCoordinate dw, const JCoordinate dh);
	virtual void	Receive(JBroadcaster* sender, const Message& message);

	virtual JBoolean	WillAcceptDrop(const JArray<Atom>& typeList, Atom* action,
									   const Time time, const JXWidget* source);
	virtual void		HandleDNDEnter();
	virtual void		HandleDNDHere(const JPoint& pt, const JXWidget* source);
	virtual void		HandleDNDLeave();
	virtual void		HandleDNDDrop(const JPoint& pt, const JArray<Atom>& typeList,
									  const Atom action, const Time time,
									  const JXWidget* source);

	virtual void	AdjustStylesBeforeRecalc(const JString& buffer, JRunArray<Font>* styles,
											 JIndexRange* recalcRange, JIndexRange* redrawRange,
											 const JBoolean deletion);

private:

	JString		itsBasePath;
	JBoolean	itsAllowInvalidFileFlag;
	JBoolean	itsRequireReadFlag;
	JBoolean	itsRequireWriteFlag;
	JBoolean	itsRequireExecFlag;
	JBoolean	itsExpectURLDropFlag;

private:

	JBoolean	GetDroppedFileName(const Time time, JString* fileName);

	// not allowed

	JXFileInput(const JXFileInput& source);
	const JXFileInput& operator=(const JXFileInput& source);
};


/******************************************************************************
 GetBasePath

 ******************************************************************************/

inline const JString&
JXFileInput::GetBasePath()
	const
{
	return itsBasePath;
}

/******************************************************************************
 ClearBasePath

 ******************************************************************************/

inline void
JXFileInput::ClearBasePath()
{
	itsBasePath.Clear();
}

/******************************************************************************
 Allow invalid file

 ******************************************************************************/

inline JBoolean
JXFileInput::WillAllowInvalidFile()
	const
{
	return itsAllowInvalidFileFlag;
}

inline void
JXFileInput::ShouldAllowInvalidFile
	(
	const JBoolean allow
	)
{
	itsAllowInvalidFileFlag = allow;
}

/******************************************************************************
 Require readable file

 ******************************************************************************/

inline JBoolean
JXFileInput::WillRequireReadable()
	const
{
	return itsRequireReadFlag;
}

inline void
JXFileInput::ShouldRequireReadable
	(
	const JBoolean require
	)
{
	itsRequireReadFlag = require;
}

/******************************************************************************
 Require writable file

 ******************************************************************************/

inline JBoolean
JXFileInput::WillRequireWritable()
	const
{
	return itsRequireWriteFlag;
}

inline void
JXFileInput::ShouldRequireWritable
	(
	const JBoolean require
	)
{
	itsRequireWriteFlag = require;
}

/******************************************************************************
 Require executable file

 ******************************************************************************/

inline JBoolean
JXFileInput::WillRequireExecutable()
	const
{
	return itsRequireExecFlag;
}

inline void
JXFileInput::ShouldRequireExecutable
	(
	const JBoolean require
	)
{
	itsRequireExecFlag = require;
}

#endif
