/******************************************************************************
 JXHelpManager.h

	Interface for the JXHelpManager class

	Copyright  1997-98 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXHelpManager
#define _H_JXHelpManager

#include <JXDirector.h>
#include <JXMenu.h>		// need definition of JXMenu::Style

class JXHelpDirector;
class JXPSPrinter;
class JXEditHelpPrefsDialog;

class JXHelpManager : public JXDirector
{
public:

	JXHelpManager(const JXMenu::Style menuStyle);

	virtual ~JXHelpManager();

	JBoolean	HasTOC() const;
	void		ShowTOC();
	void		SetTOCSectionName(const JCharacter* name);

	void	RegisterSection(const JCharacter* name, const JCharacter* title,
							const JCharacter* text);
	void	ShowSection(const JCharacter* name, JXHelpDirector* helpDir = NULL);
	void	ShowURL(const JCharacter* url, JXHelpDirector* helpDir = NULL);
	void	CloseAll();

	void	EditPrefs();
	void	SaveWindowPrefs(JXWindow* window);
	void	ReadSetup(istream& input);
	void	WriteSetup(ostream& output) const;

	const JString&	GetViewURLCmd() const;
	void			SetViewURLCmd(const JCharacter* cmd);

	const JString&	GetSendMailCmd() const;
	void			SetSendMailCmd(const JCharacter* cmd);

	// upgrading from previous versions -- public because used by other classes

	static void	ConvertVarNames(JString* s, const JCharacter* varNameList);

protected:

	virtual void	DirectorClosed(JXDirector* theDirector);
	virtual void	Receive(JBroadcaster* sender, const Message& message);

private:

	struct SectionInfo
	{
		const JCharacter*	name;
		const JCharacter*	title;
		const JCharacter*	text;
		JXHelpDirector*		dir;

		SectionInfo()
			:
			name(NULL), title(NULL), text(NULL), dir(NULL)
		{ };

		SectionInfo(const JCharacter* n, const JCharacter* t,
					const JCharacter* s)
			:
			name(n), title(t), text(s), dir(NULL)
		{ };
	};

private:

	const JXMenu::Style		itsMenuStyle;
	JArray<SectionInfo>*	itsSections;
	const JCharacter*		itsTOCSectionName;	// NULL if not registered

	JString*				itsViewURLCmd;
	JString*				itsSendMailCmd;
	JString*				itsDefWindowGeom;

	JXPSPrinter*			itsPrinter;
	JXEditHelpPrefsDialog*	itsPrefsDialog;

private:

	static JOrderedSetT::CompareResult
		CompareSections(const SectionInfo& s1, const SectionInfo& s2);

	// not allowed

	JXHelpManager(const JXHelpManager& source);
	const JXHelpManager& operator=(const JXHelpManager& source);
};


/******************************************************************************
 Table of Contents

 ******************************************************************************/

inline JBoolean
JXHelpManager::HasTOC()
	const
{
	return JI2B(itsTOCSectionName != NULL);
}

inline void
JXHelpManager::SetTOCSectionName
	(
	const JCharacter* name
	)
{
	itsTOCSectionName = name;
}

/******************************************************************************
 Outsourced commands

 ******************************************************************************/

inline const JString&
JXHelpManager::GetViewURLCmd()
	const
{
	return *itsViewURLCmd;
}

inline const JString&
JXHelpManager::GetSendMailCmd()
	const
{
	return *itsSendMailCmd;
}

#endif
