/******************************************************************************
 JXImageButton.cc

	Maintains a pushable button with a JXImage.

	BASE CLASS = JXButton

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXImageButton.h>
#include <JXWindowPainter.h>
#include <JXImage.h>
#include <JXColormap.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXImageButton::JXImageButton
	(
	JXContainer*		enclosure,
	const HSizingOption	hSizing,
	const VSizingOption	vSizing,
	const JCoordinate	x,
	const JCoordinate	y,
	const JCoordinate	w,
	const JCoordinate	h
	)
	:
	JXButton(enclosure, hSizing, vSizing, x,y, w,h)
{
	itsImage         = NULL;
	itsOwnsImageFlag = kTrue;
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXImageButton::~JXImageButton()
{
	if (itsOwnsImageFlag)
		{
		delete itsImage;
		}
}

/******************************************************************************
 SetBitmap

 ******************************************************************************/

void
JXImageButton::SetBitmap
	(
	const JConstBitmap&	bitmap,
	const JColorIndex	origForeColor,
	const JColorIndex	origBackColor
	)
{
	const JColorIndex foreColor =
		(origForeColor == kJXTransparentColor ?
		 (GetColormap())->GetBlackColor() : origForeColor);

	const JColorIndex backColor =
		(origBackColor == kJXTransparentColor ?
		 (GetColormap())->GetDefaultBackColor() : origBackColor);

	if (itsOwnsImageFlag)
		{
		delete itsImage;
		}

	itsImage = new JXImage(GetDisplay(), GetColormap(), bitmap, foreColor, backColor);
	assert( itsImage != NULL );

	itsOwnsImageFlag = kTrue;

	SetBackColor(backColor);
	Refresh();
}

/******************************************************************************
 SetImage

 ******************************************************************************/

void
JXImageButton::SetImage
	(
	JXImage*			image,
	const JBoolean		widgetOwnsImage,
	const JColorIndex	origBackColor
	)
{
	const JColorIndex backColor =
		(origBackColor == kJXTransparentColor ?
		 (GetColormap())->GetDefaultBackColor() : origBackColor);

	if (itsOwnsImageFlag)
		{
		delete itsImage;
		}

	itsImage         = image;
	itsOwnsImageFlag = widgetOwnsImage;

	SetBackColor(backColor);
	Refresh();
}

/******************************************************************************
 Draw (virtual protected)

 ******************************************************************************/

void
JXImageButton::Draw
	(
	JXWindowPainter&	p,
	const JRect&		rect
	)
{
	if (itsImage != NULL)
		{
		p.Image(*itsImage, itsImage->GetBounds(), GetBounds());
		}
}
