/******************************************************************************
 JXTextClipboard.h

	Interface for the JXTextClipboard class

	Copyright  1997-99 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXTextClipboard
#define _H_JXTextClipboard

#include <JXTEBase.h>

class JXTextClipboard : public JXTEBase
{
public:

	JXTextClipboard(JXContainer* enclosure);

	virtual ~JXTextClipboard();

	JBoolean	SetClipboard(const JCharacter* text);
	JBoolean	UpdateClipboard();

private:

	JBoolean	GrabClipboard();

	// not allowed

	JXTextClipboard(const JXTextClipboard& source);
	const JXTextClipboard& operator=(const JXTextClipboard& source);
};


/******************************************************************************
 SetClipboard

	Place the given text on the clipboard.  Returns kTrue if successful.

 ******************************************************************************/

inline JBoolean
JXTextClipboard::SetClipboard
	(
	const JCharacter* text
	)
{
	Paste(text);
	return GrabClipboard();
}

/******************************************************************************
 UpdateClipboard

	If there is text on the clipboard, this copies it and then grabs
	ownership of the clipboard.  Returns kTrue if there was text on
	the clipboard.

 ******************************************************************************/

inline JBoolean
JXTextClipboard::UpdateClipboard()
{
	Paste();				// get the clipboard contents
	return GrabClipboard();
}

#endif
