/******************************************************************************
 JXTextMenu.h

	Interface for the JXTextMenu class

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXTextMenu
#define _H_JXTextMenu

#include <JXMenu.h>
#include <JFontStyle.h>
#include <JXPM.h>

class JXTextMenuData;
class JXImage;

class JXTextMenu : public JXMenu
{
public:

	JXTextMenu(const JCharacter* title, JXContainer* enclosure,
			   const HSizingOption hSizing, const VSizingOption vSizing,
			   const JCoordinate x, const JCoordinate y,
			   const JCoordinate w, const JCoordinate h);

	JXTextMenu(JXImage* image, const JBoolean menuOwnsImage,
			   JXContainer* enclosure,
			   const HSizingOption hSizing, const VSizingOption vSizing,
			   const JCoordinate x, const JCoordinate y,
			   const JCoordinate w, const JCoordinate h);

	JXTextMenu(JXMenu* owner, const JIndex itemIndex, JXContainer* enclosure);

	virtual ~JXTextMenu();

	void	SetMenuItems(const JCharacter* menuStr);

	void	InsertItem(const JIndex index, const JCharacter* str,
					   const JBoolean isCheckbox = kFalse,
					   const JBoolean isRadio = kFalse,
					   const JCharacter* shortcuts = NULL,
					   const JCharacter* nmShortcut = NULL,
					   const JCharacter* id = NULL);
	void	PrependItem(const JCharacter* str,
						const JBoolean isCheckbox = kFalse,
						const JBoolean isRadio = kFalse,
						const JCharacter* shortcuts = NULL,
						const JCharacter* nmShortcut = NULL,
						const JCharacter* id = NULL);
	void	AppendItem(const JCharacter* str,
					   const JBoolean isCheckbox = kFalse,
					   const JBoolean isRadio = kFalse,
					   const JCharacter* shortcuts = NULL,
					   const JCharacter* nmShortcut = NULL,
					   const JCharacter* id = NULL);

	const JString&	GetItemText(const JIndex index) const;
	void			SetItemText(const JIndex index, const JCharacter* str);

	const JCharacter*	GetItemFontName(const JIndex index) const;
	JSize				GetItemFontSize(const JIndex index) const;
	JFontStyle			GetItemFontStyle(const JIndex index) const;
	void				GetItemFont(const JIndex index, JString* name,
									JSize* size, JFontStyle* style) const;

	void	SetItemFontName(const JIndex index, const JCharacter* name);
	void	SetItemFontSize(const JIndex index, const JSize size);
	void	SetItemFontStyle(const JIndex index, const JFontStyle& style);
	void	SetItemFont(const JIndex index, const JCharacter* name,
						const JSize size, const JFontStyle& style = JFontStyle());
	void	SetItemFont(const JIndex index, const JFontID id,
						const JSize size, const JFontStyle& style = JFontStyle());

	JBoolean	GetItemImage(const JIndex index, const JXImage** image) const;
	void		SetItemImage(const JIndex index, JXImage* image,
							 const JBoolean menuOwnsImage);
	void		SetItemImage(const JIndex index, const JXPM& data);
	void		ClearItemImage(const JIndex index);

	JBoolean	GetItemNMShortcut(const JIndex index, JString* str) const;
	void		SetItemNMShortcut(const JIndex index, const JCharacter* str);

	JBoolean	HasSeparatorAfter(const JIndex index) const;
	void		ShowSeparatorAfter(const JIndex index, const JBoolean show = kTrue);

	JBoolean	HeightCompressed() const;
	void		CompressHeight(const JBoolean compress = kTrue);

	// called by JXWindow

	void	HandleNMShortcut(const JIndex index, const JXKeyModifiers& modifiers);

	// provides safe downcasting

	virtual JXTextMenu*			CastToJXTextMenu();
	virtual const JXTextMenu*	CastToJXTextMenu() const;

protected:

	virtual JXMenuDirector*	CreateWindow(JXWindowDirector* supervisor);
	virtual void			AdjustPopupChoiceTitle(const JIndex index);

	JXTextMenuData*	GetTextMenuData();

private:

	JXTextMenuData*	itsTextMenuData;

private:

	void	JXTextMenuX();

	// not allowed

	JXTextMenu(const JXTextMenu& source);
	const JXTextMenu& operator=(const JXTextMenu& source);
};


/******************************************************************************
 GetTextMenuData (protected)

 ******************************************************************************/

inline JXTextMenuData*
JXTextMenu::GetTextMenuData()
{
	return itsTextMenuData;
}

#endif
