/******************************************************************************
 TestPopupChoiceDialog.cc

	BASE CLASS = JXDialogDirector

	Written by John Lindal.

 ******************************************************************************/

#include "TestPopupChoiceDialog.h"
#include "SmileyBitmaps.h"
#include <JXWindow.h>
#include <JXTextButton.h>
#include <JXFontNameMenu.h>
#include <JXFontSizeMenu.h>
#include <JXImageMenu.h>
#include <JXImage.h>
#include <JXColormap.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

TestPopupChoiceDialog::TestPopupChoiceDialog
	(
	JXWindowDirector* supervisor
	)
	:
	JXDialogDirector(supervisor, kTrue)
{
	BuildWindow();
}

/******************************************************************************
 Destructor

 ******************************************************************************/

TestPopupChoiceDialog::~TestPopupChoiceDialog()
{
}

/******************************************************************************
 BuildWindow (private)

 ******************************************************************************/

void
TestPopupChoiceDialog::BuildWindow()
{
// begin JXLayout

    JXWindow* window = new JXWindow(this, 230,170, "");
    assert( window != NULL );
    SetWindow(window);

    JXTextButton* cancelButton =
        new JXTextButton("Cancel", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 30,140, 70,20);
    assert( cancelButton != NULL );

    JXTextButton* okButton =
        new JXTextButton("OK", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 129,139, 72,22);
    assert( okButton != NULL );
    okButton->SetShortcuts("^M");

    JXFontNameMenu* fontMenu =
        JXFontNameMenu::Create("Font", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 20,20, 190,30);
    assert( fontMenu != NULL );

    JXFontSizeMenu* sizeMenu =
        JXFontSizeMenu::Create(fontMenu, "Size", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 20,60, 190,30);
    assert( sizeMenu != NULL );

    JXImageMenu* iconMenu =
        new JXImageMenu("Icons", 2, window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 20,100, 190,30);
    assert( iconMenu != NULL );

// end JXLayout

	window->SetTitle("Testing PopupChoice Menus");
	SetButtons(okButton, cancelButton);

	fontMenu->SetTitle("Font");
	fontMenu->SetToPopupChoice();

	sizeMenu->SetTitle("Size");
	sizeMenu->SetToPopupChoice();

	// set up icon menu

	JXDisplay* display   = window->GetDisplay();
	JXColormap* colormap = window->GetColormap();

	static const JColorIndex kSmileyColor[] =
	{
		colormap->GetWhiteColor(),
		colormap->GetRedColor(),
		colormap->GetBlueColor(),
		colormap->GetBlackColor()
	};

	JXImage* titleImage = NULL;
	for (JIndex i=0; i<kSmileyBitmapCount; i++)
		{
		JXImage* image = new JXImage(display, colormap, kSmileyBitmap[i], kSmileyColor[i]);
		assert( image != NULL );
		iconMenu->AppendItem(image, kTrue);

		if (i == 0)
			{
			titleImage = image;
			}
		}

	// set title to image so SetToPopupChoice() will change the title
	iconMenu->SetTitleImage(titleImage, kFalse);

	iconMenu->SetUpdateAction(JXMenu::kDisableNone);
	iconMenu->SetToPopupChoice(kTrue, 1);

	// We should actually set all the items on iconMenu to be radio buttons
	// and then ListenTo() it so we know what the selection is, but this window
	// does nothing, so we don't bother.
}
