/******************************************************************************
 TestSaveFileDialog.cc

	Clients must call BuildWindow() after constructing the object.

	BASE CLASS = JXSaveFileDialog

	Written by John Lindal.

 ******************************************************************************/

#include "TestSaveFileDialog.h"
#include <JXWindow.h>
#include <JXStaticText.h>
#include <JXSaveFileInput.h>
#include <JXPathInput.h>
#include <JXTextButton.h>
#include <JXTextCheckbox.h>
#include <JXRadioGroup.h>
#include <JXTextRadioButton.h>
#include <JXPathHistoryMenu.h>
#include <JXScrollbarSet.h>
#include <JXNewDirButton.h>
#include <JString.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

TestSaveFileDialog::TestSaveFileDialog
	(
	JXDirector*								supervisor,
	JUNIXDirInfo*							dirInfo,
	const JCharacter*						fileFilter,
	const TestChooseSaveFile::SaveFormat	saveFormat
	)
	:
	JXSaveFileDialog(supervisor, dirInfo, fileFilter)
{
	itsSaveFormat = saveFormat;
}

/******************************************************************************
 Destructor

 ******************************************************************************/

TestSaveFileDialog::~TestSaveFileDialog()
{
}

/******************************************************************************
 GetSaveFormat

	itsSaveFormat is only stored for use by BuildWindow().

 ******************************************************************************/

TestChooseSaveFile::SaveFormat
TestSaveFileDialog::GetSaveFormat()
	const
{
	return (TestChooseSaveFile::SaveFormat) itsFormatRG->GetSelectedItem();
}

/******************************************************************************
 BuildWindow

 ******************************************************************************/

void
TestSaveFileDialog::BuildWindow
	(
	const JCharacter*	origName,
	const JCharacter*	prompt,
	const JCharacter*	message
	)
{
// begin JXLayout

    JXWindow* window = new JXWindow(this, 310,360, "");
    assert( window != NULL );
    SetWindow(window);

    JXScrollbarSet* scrollbarSet =
        new JXScrollbarSet(window,
                    JXWidget::kHElastic, JXWidget::kFixedBottom, 20,110, 180,140);
    assert( scrollbarSet != NULL );

    JXTextButton* saveButton =
        new JXTextButton("Save", window,
                    JXWidget::kFixedRight, JXWidget::kFixedBottom, 219,249, 72,22);
    assert( saveButton != NULL );
    saveButton->SetShortcuts("^M");

    JXTextButton* cancelButton =
        new JXTextButton("Cancel", window,
                    JXWidget::kFixedRight, JXWidget::kFixedBottom, 220,280, 70,20);
    assert( cancelButton != NULL );
    cancelButton->SetShortcuts("^[");

    JXTextButton* homeButton =
        new JXTextButton("Home", window,
                    JXWidget::kFixedRight, JXWidget::kFixedBottom, 250,110, 40,20);
    assert( homeButton != NULL );
    homeButton->SetShortcuts("#H");

    JXStaticText* pathLabel =
        new JXStaticText("Path:", window,
                    JXWidget::kFixedLeft, JXWidget::kFixedBottom, 20,20, 40,20);
    assert( pathLabel != NULL );

    JXSaveFileInput* fileNameInput =
        new JXSaveFileInput(window,
                    JXWidget::kHElastic, JXWidget::kFixedBottom, 20,280, 180,20);
    assert( fileNameInput != NULL );

    JXPathInput* pathInput =
        new JXPathInput(window,
                    JXWidget::kHElastic, JXWidget::kFixedBottom, 60,20, 200,20);
    assert( pathInput != NULL );

    JXTextCheckbox* showHiddenCB =
        new JXTextCheckbox("Show hidden files", window,
                    JXWidget::kFixedLeft, JXWidget::kFixedBottom, 60,80, 130,20);
    assert( showHiddenCB != NULL );
    showHiddenCB->SetShortcuts("#S");

    JXStaticText* promptLabel =
        new JXStaticText("", window,
                    JXWidget::kHElastic, JXWidget::kFixedBottom, 20,260, 180,20);
    assert( promptLabel != NULL );

    JXStaticText* filterLabel =
        new JXStaticText("Filter:", window,
                    JXWidget::kFixedLeft, JXWidget::kFixedBottom, 20,50, 40,20);
    assert( filterLabel != NULL );

    JXInputField* filterInput =
        new JXInputField(window,
                    JXWidget::kHElastic, JXWidget::kFixedBottom, 60,50, 200,20);
    assert( filterInput != NULL );

    JXStaticText* obj1 =
        new JXStaticText("Save as:", window,
                    JXWidget::kFixedLeft, JXWidget::kFixedBottom, 20,320, 60,20);
    assert( obj1 != NULL );

    itsFormatRG =
        new JXRadioGroup(window,
                    JXWidget::kFixedLeft, JXWidget::kFixedBottom, 90,310, 192,36);
    assert( itsFormatRG != NULL );

    JXTextRadioButton* obj2 =
        new JXTextRadioButton(TestChooseSaveFile::kGIFFormat, "GIF", itsFormatRG,
                    JXWidget::kFixedLeft, JXWidget::kFixedTop, 10,5, 50,20);
    assert( obj2 != NULL );

    JXTextRadioButton* obj3 =
        new JXTextRadioButton(TestChooseSaveFile::kJPEGFormat, "JPEG", itsFormatRG,
                    JXWidget::kFixedLeft, JXWidget::kFixedTop, 120,5, 60,20);
    assert( obj3 != NULL );

    JXTextRadioButton* obj4 =
        new JXTextRadioButton(TestChooseSaveFile::kPNGFormat, "PNG", itsFormatRG,
                    JXWidget::kFixedLeft, JXWidget::kFixedTop, 60,5, 50,20);
    assert( obj4 != NULL );

    JXPathHistoryMenu* pathHistory =
        new JXPathHistoryMenu(1, "", window,
                    JXWidget::kFixedRight, JXWidget::kFixedBottom, 260,20, 30,20);
    assert( pathHistory != NULL );

    JXStringHistoryMenu* filterHistory =
        new JXStringHistoryMenu(1, "", window,
                    JXWidget::kFixedRight, JXWidget::kFixedBottom, 260,50, 30,20);
    assert( filterHistory != NULL );

    JXTextButton* upButton =
        new JXTextButton("Up", window,
                    JXWidget::kFixedRight, JXWidget::kFixedBottom, 220,110, 30,20);
    assert( upButton != NULL );
    upButton->SetShortcuts("#U");

    JXNewDirButton* newDirButton =
        new JXNewDirButton(window,
                    JXWidget::kFixedRight, JXWidget::kFixedBottom, 220,140, 70,20);
    assert( newDirButton != NULL );

// end JXLayout

	SetObjects(scrollbarSet, promptLabel, prompt, fileNameInput, origName,
			   pathLabel, pathInput, pathHistory,
			   filterLabel, filterInput, filterHistory,
			   saveButton, cancelButton, upButton, homeButton, newDirButton,
			   showHiddenCB, message);

	itsFormatRG->SelectItem(itsSaveFormat);
	ListenTo(itsFormatRG);

	HandleFormatChange(itsFormatRG->GetSelectedItem());
}

/******************************************************************************
 Receive (virtual protected)

 ******************************************************************************/

void
TestSaveFileDialog::Receive
	(
	JBroadcaster*	sender,
	const Message&	message
	)
{
	if (sender == itsFormatRG && message.Is(JXRadioGroup::kSelectionChanged))
		{
		const JXRadioGroup::SelectionChanged* selection =
			dynamic_cast(const JXRadioGroup::SelectionChanged*, &message);
		assert( selection != NULL );
		HandleFormatChange(selection->GetID());
		}

	else
		{
		JXSaveFileDialog::Receive(sender, message);
		}
}

/******************************************************************************
 HandleFormatChange (private)

 ******************************************************************************/

void
TestSaveFileDialog::HandleFormatChange
	(
	const JIndex id
	)
{
	JXInputField* fileNameInput = GetFileNameInput();
	JString fileName            = fileNameInput->GetText();
	const JSize origLength      = fileName.GetLength();

	if (origLength == 0)
		{
		return;
		}

	JIndex dotIndex;
	if (fileName.LocateLastSubstring(".", &dotIndex) && dotIndex > 1)
		{
		fileName.RemoveSubstring(dotIndex, origLength);
		}
	else
		{
		dotIndex = origLength + 1;
		}

	if (id == TestChooseSaveFile::kGIFFormat)
		{
		fileName += ".gif";
		}
	else if (id == TestChooseSaveFile::kPNGFormat)
		{
		fileName += ".png";
		}
	else
		{
		assert( id == TestChooseSaveFile::kJPEGFormat );
		fileName += ".jpg";
		}

	fileNameInput->SetText(fileName);
	fileNameInput->SetSelection(1, dotIndex-1);
}
