/*
 * Copyright (c) 1994, Jettero Heller
 *
 * You may distribute this source code under the terms of the license
 * in the COPYING file.
 *
 */

/* Include(s) */
#include <Xarm/PasswordF.h>
#include <string.h>
#include <stdlib.h>
#include <Xarm/AppContext.h>
#include <Xarm/PushB.h>
#include <Xarm/ToggleB.h>
#include <Xarm/RowColumn.h>
#include <Xarm/MessageB.h>
#include <string>

#if defined(XARM_HAS_NAMESPACES)
using namespace std;
#endif

/* The easiest way to specify ToolTip colors is in resources */

_XtString fallbacks[] = {
    "*toolTipLabel*Foreground: black",
    "*toolTipLabel*Background: yellow",
    NULL
};

/* Declaration(s) */
class Application: public AppContext
{
private:
    void onActivate(Widget,XtPointer,XtPointer);
    void onExit(Widget,XtPointer,XtPointer);
    void onToggleEdit(Widget,XtPointer,XtPointer);
    void exit(Widget,XtPointer,XtPointer);

    PasswordField  *field;
    PushButton     *button;
    ToggleButton   *canPaste;

public:
    Application(char *app_class,int &argc_in_out, char **argv_in_out);
};

int
main (int argc, char **argv)
{
   // initialize application
   Application app("Xarm Password Example",argc,argv);

   // realize application
   app.realize();

   // start the main loop
   app.mainLoop();

   // NOTE: app.mainLoop() willl return!
   return EXIT_SUCCESS;
}

Application::Application(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext(app_class, NULL, 0, argc_in_out, argv_in_out, fallbacks)
{

    // install window manager message handler(s)
    Atom proto = addWMProtocol(XA_WM_DELETE_WINDOW);
    addWMProtocolCallback(this, &Application::onExit, widget(),proto);

    title(app_class);

    // install window(s) into the application window
    RowColumn *rc = new RowColumn(widget());
    field = new PasswordField(rc->widget());
    field->addToolTip("Type text here that will not be echoed");
    button = new PushButton(rc->widget(),"Decrypt");
    button->addToolTip("Decrypt typed in text");
    canPaste = new ToggleButton(rc->widget(), "Enable Cut/Paste & Editing");
    canPaste->addToolTip("Toggles editing features");

    // Preload the value...
    field->value("Testing");

    addCallback(this, &Application::onActivate,   button,   XmNactivateCallback);
    addCallback(this, &Application::onToggleEdit, canPaste, XmNvalueChangedCallback);

    rc->manage();
}

void Application::onActivate(Widget w, XtPointer, XtPointer)
{

    static char fillChars[]    = { '*', '#', '$', '%', '-', '+', '@', 'X', '\0' };
    static int  nextChar       = 0;
    static MessageDialog *diag = NULL;

    if (diag == NULL) {
        diag = new MessageDialog(w, "passwdDialog");
        diag->dialogTitle("Decryption");
        XtUnmanageChild(diag->getChild(XmDIALOG_CANCEL_BUTTON));
        XtUnmanageChild(diag->getChild(XmDIALOG_HELP_BUTTON));
    }

    // Give the dialog a little bit more to say...

    string msg = "The password is: ";

    msg += field->password();

    diag->messageString((char *)msg.c_str());
    diag->manage();
    if (fillChars[++nextChar] == '\0') nextChar = 0;

    field->fillChar(fillChars[nextChar]);

    field->value(NULL);
}

void Application::onToggleEdit(Widget, XtPointer, XtPointer)
{
    field->enablePaste(canPaste->set());
}

void Application::exit(Widget, XtPointer, XtPointer)
{
    quit();
}

void Application::onExit(Widget w, XtPointer, XtPointer)
{
    static QuestionDialog *diag = NULL;

    if (diag == NULL) {
        diag = new QuestionDialog(w,"Do you really want to quit?");
        XtUnmanageChild(diag->getChild(XmDIALOG_HELP_BUTTON));
    }

    diag->dialogTitle("Exit Dialog");
    addCallback(this, &Application::exit, diag, XmNokCallback);
    diag->manage();
}
