/* Include(s) */
#include <string>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>

#if defined(XARM_HAS_NEWHEADERS)
#include <iostream>
#else
#include <iostream.h>
#endif

#include <Xarm/AppContext.h>
#include <Xarm/Form.h>
#include <Xarm/Frame.h>
#include <Xarm/Label.h>
#include <Xarm/Separator.h>
#include <Xarm/TextF.h>
#include <Xarm/RowColumn.h>
#include <Xarm/PushB.h>
#include <Xarm/XarmXpm.h>
#include <Xarm/XarmTreeList.h>
#include <Xm/DragDrop.h>
#include "drive.xpm"
#include "open_dir.xpm"
#include "close_dir.xpm"
#include "file.xpm"
#include "file.bm"
#include "file_m.bm"
#include "dir.bm"
#include "dir_m.bm"
#include "EmptyTrash.xpm"
#include "FullTrash.xpm"

#if defined(XARM_HAS_NAMESPACES)
using namespace std;
#endif

#if defined(XARM_HAS_NAMESPACES)
using namespace std;
#endif

#ifdef XARM_HAS_XBAE

//************************************************************
//************************************************************
//***                !!!!!!WARNING!!!!!!                   ***
//***                                                      ***
//***    You must have these two font entries specified!   ***
//***                                                      ***
//***                !!!!!!WARNING!!!!!!                   ***
//************************************************************
//************************************************************

_XtString fallbacks[] = {
"treedemo*labelFont:      -*-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*",
"treedemo*fontList:       -adobe-times-medium-r-*-*-12-*-*-*-*-*-*-*",
"",
NULL
};

#define SCANNED_BIT   0x01
#define FAKE_BIT      0x02
#define DIR_BIT       0x04
#define FILE_BIT      0x08
#define LINK_BIT      0x10

/* Declaration(s) */
class Application: public AppContext
{

private:

    XarmTreeList *myTree;
    Pixmap pmDrive, pmOpenDir, pmCloseDir, pmFile;
    Pixmap emptyTrash, fullTrash;

    Widget dndFileIcon;
    Widget dndDirIcon;

    XarmTreeItem *rootItem;
    XarmTreeItem *rcItem;

    Form      *mainForm;
    Form      *treeForm;
    Frame     *treeFrame;
    Form      *workForm;
    Frame     *workFrame;

    TextField *fnText;
    TextField *tpText;
    TextField *szText;

    PopupMenu  *rcMenu;
    Label      *rcmLabel;
    PushButton *ecButton;
    PushButton *statButton;

    Label      *trashCan;
    Label      *ndCount;
    Label      *nfCount;
    Label      *lnName;

    Atom dndFileAtom;
    Atom dndDirAtom;

    int  nFT;
    int  nDT;

    char nameBuf[1024];

    void Quit(Widget, XtPointer, XtPointer);
    void onTreeSelect(Widget, XtPointer, XtPointer);
    void onTreeExpand(Widget, XtPointer, XtPointer);
    void onTreeRightClick(Widget, XtPointer, XtPointer);
    void onRCExpand(Widget, XtPointer, XtPointer);
    void onRCSelect(Widget, XtPointer, XtPointer);
    void onStartDrag(Widget, XtPointer, XtPointer);

    void readDir(const char *dirName, XarmTreeItem *parent);
    void getName(XarmTreeItem *);

    bool isLess(const XarmTreeItem *item, const char *name, int flags);

    Pixmap loadPixmap(char **pdata);

public:
    Application(char *app_class,int &argc_in_out, char **argv_in_out);

    void dropItem(const XarmTreeItem *item);
};

static Application *theApp = NULL;

//************************************************************
//*   These functions are here like this until I wrap the    *
//* generic Motif Drag and Drop interface for Xarm like I    *
//* have already done for CDE. (CDE was easier to do :-)     *
//************************************************************

// ConvertProc() is called for the Drag Source to convert the DND data...

static Boolean ConvertProc(Widget         wid,
			   Atom          *selection,
			   Atom          *target,
			   Atom          *type_return,
			   XtPointer     *value_return,
			   unsigned long *length_return,
			   int           *format_return)
{

    Atom FileAtom, DirAtom, MotifAtom;
    Display *dpy;
    XarmTreeItem *item;
    XarmTreeItem *buffer;

    dpy = XtDisplay(wid);
    FileAtom  = XmInternAtom(dpy, "XARM_TREE_FILE", False);
    DirAtom   = XmInternAtom(dpy, "XARM_TREE_DIR",  False);
    MotifAtom = XmInternAtom(dpy, "_MOTIF_DROP",    False);

    if (*selection != MotifAtom) return False;

    XtVaGetValues(wid, XmNclientData, (XtPointer)(&item), NULL);

    if (item == NULL) return False;

    buffer = (XarmTreeItem *)XtMalloc(sizeof(XarmTreeItem) + strlen(item->text) + 1);

    memcpy(buffer, item, sizeof(XarmTreeItem));
    strcpy(buffer->text, item->text);

    if ((int)(item->userData) & DIR_BIT) *type_return = DirAtom;
    else                          *type_return = FileAtom;

    *value_return = (XtPointer)(buffer);
    *length_return = sizeof(XarmTreeItem) + strlen(item->text) + 1;
    *format_return = 8;

    return True;
}

// TransferProc() is the drop site function that receives the data...

static void TransferProc(Widget         wid,
			 XtPointer      clientData,
			 Atom          *selType,
			 Atom          *type,
			 XtPointer      value,
			 unsigned long *length,
			 int            format )
{
    XarmTreeItem *item = (XarmTreeItem *)value;

    theApp->dropItem(item);
}

// HandleDrop() is called for the Drop Site to allow/deny the drop

static void HandleDrop(Widget wid, XtPointer clientData, XtPointer callData)
{
    Display           *dpy;
    Atom               FileAtom;
    Atom               DirAtom;
    XmDropProcCallback DropData;
    Widget             dc;
    Arg                args[10];
    Cardinal           numExportTargets;
    Atom              *exportTargets;
    Atom               reqType;
    int                x;
    XmDropTransferEntryRec transferEntries[1];

    dpy = XtDisplay(wid);
    FileAtom = XmInternAtom(dpy, "XARM_TREE_FILE", False);
    DirAtom  = XmInternAtom(dpy, "XARM_TREE_DIR",  False);

    DropData = (XmDropProcCallback)callData;

    dc = DropData->dragContext;
    x = 0;
    XtSetArg(args[x], XmNexportTargets, &exportTargets); x++;
    XtSetArg(args[x], XmNnumExportTargets, &numExportTargets); x++;
    XtGetValues(dc, args, x);

    reqType = 0;
    for (x = 0; x < numExportTargets; ++x) {
      if ((exportTargets[x] == FileAtom) ||
	  (exportTargets[x] == DirAtom)) {
	  reqType = exportTargets[x];
	  break;
      }
    }

    x = 0;
    if ((reqType == 0) ||
	(DropData->dropAction != XmDROP) ||
	(DropData->operation != XmDROP_MOVE)) {
        // Fail!
        XtSetArg(args[x], XmNtransferStatus, XmTRANSFER_FAILURE); x++;
	XtSetArg(args[x], XmNnumDropTransfers, 0); x++;
    } else {
        transferEntries[0].target = reqType;
	XtSetArg(args[x], XmNdropTransfers,    transferEntries); x++;
	XtSetArg(args[x], XmNnumDropTransfers, 1);               x++;
	XtSetArg(args[x], XmNtransferProc,     TransferProc);    x++;
    }

    XmDropTransferStart(dc, args, x);
}

char *basename(char *name)
{
   char *s;

   if((s=strrchr(name,'/'))!=NULL)
   {
      s++;
   }
   else
   {
      s = name;
   }
   return s;
}

int main (int argc, char **argv)
{
   // initialize application
   Application app(basename(argv[0]),argc,argv);

   // realize application
   app.realize();

   // start the main loop
   app.mainLoop();

   return EXIT_SUCCESS;
}

Pixmap Application::loadPixmap(char **data)
{
    static Colormap _cmap;

    Window root;
    XarmXpmAttributes xpm_attrib;
    Pixmap mask;
    Pixmap pixmap_to_return;
    XarmXpmColorSymbol XpmTransparentColor[1] = { { NULL, "none", 0 } };

    /* The widget might not have a window yet so just use the root window */
    root = RootWindowOfScreen(screen());
    mask = 0;

    XpmTransparentColor[0].pixel = workForm->background();

    /* initialize colormap if it hasn't been done */
    if(_cmap == (Colormap) NULL) {
        XWindowAttributes w_attrib;
        XGetWindowAttributes(display(),root,&w_attrib);
        _cmap=w_attrib.colormap;
    }

    xpm_attrib.colorsymbols = XpmTransparentColor;
    xpm_attrib.numsymbols = 1;
    xpm_attrib.depth = depth();
    xpm_attrib.colormap=_cmap;
    xpm_attrib.closeness=65535;
    xpm_attrib.valuemask=XarmXpmSize | XarmXpmReturnPixels | XarmXpmDepth | XarmXpmColorSymbols
                         | XarmXpmColormap | XarmXpmCloseness;
    if(_XarmXpmCreatePixmapFromData(display(),
                                    root,
                                    const_cast<const char **>(data),
                                    &pixmap_to_return,
                                    &mask,
                                    &xpm_attrib) != XarmXpmSuccess) {
        pixmap_to_return = XmUNSPECIFIED_PIXMAP;
    }

    return pixmap_to_return;
}


bool Application::isLess(const XarmTreeItem *item, const char *name, int flags)
{
    int iFlags = (int)item->userData;

    if ((iFlags == DIR_BIT) && (flags != DIR_BIT))  return true;
    if ((flags == DIR_BIT)  && (iFlags != DIR_BIT)) return false;

    return (strcmp(item->text, name) < 0);
}


void Application::readDir(const char *dirName, XarmTreeItem *parent)
{
    DIR *dirp;
    char old_path[1024];

    if (getcwd(old_path, 1024) == NULL) return;

    dirp = opendir(dirName);

    if (dirp != NULL) {

        struct dirent *entp = readdir(dirp);

        chdir(dirName);

        while (entp != NULL) {

            struct stat statbuf;
            XarmTreeItem *newItem;
            int iFlags = 0;
            Pixmap openPM, closePM;

            if ((strcmp(entp->d_name, ".") != 0) &&
                (strcmp(entp->d_name, "..") != 0) &&
                (lstat(entp->d_name, &statbuf) == 0)) {
                if (S_ISLNK(statbuf.st_mode)) {
                    iFlags = LINK_BIT;
                    openPM = closePM = pmFile;
                } else if (S_ISDIR(statbuf.st_mode)) {
                    iFlags  = DIR_BIT;
                    openPM  = pmOpenDir;
                    closePM = pmCloseDir;
                } else {
                    iFlags = FILE_BIT;
                    openPM = closePM = pmFile;
                }

                XarmTreeItem *child = parent->children;

                if (child == NULL) {
                    newItem = myTree->addItemLast(parent,
                                                  entp->d_name,
                                                  openPM, closePM,
                                                  (XtPointer)iFlags);
                } else {
                    while ((child != NULL) && isLess(child, entp->d_name, iFlags)) child = child->next;
                    if (child == NULL) {
                        newItem = myTree->addItemLast(parent,
                                                      entp->d_name,
                                                      openPM, closePM,
                                                      (XtPointer)iFlags);
                    } else {
                        newItem = myTree->addItemBefore(child,
                                                        entp->d_name,
                                                        openPM, closePM,
                                                        (XtPointer)iFlags);
                    }
                }

                if (iFlags == DIR_BIT) {
                    // Add a fake child temporarily...
                    myTree->addItemLast(newItem,
                                        "Fake",
                                        pmFile, pmFile,
                                        (XtPointer)FAKE_BIT);
                }
            }

            entp = readdir(dirp);
        }

        closedir(dirp);
        chdir(old_path);
    }
}

void Application::Quit(Widget, XtPointer, XtPointer)
{
    quit();
}

void Application::getName(XarmTreeItem *item)
{

    char tempBuf[1024];

    XarmTreeItem *nitem = item;
    tempBuf[0] = '\0';

    while (nitem != rootItem) {
        sprintf(nameBuf, "%s/%s", nitem->text, tempBuf);
        strcpy(tempBuf, nameBuf);
        nitem = nitem->parent;
    }
    sprintf(nameBuf, "/%s", tempBuf);
}

void Application::onStartDrag(Widget, XtPointer, XtPointer cdata)
{
    XarmArg args;
    Atom    exportList[2];
    XarmTreeDragCallbackStruct *xtdcs = (XarmTreeDragCallbackStruct *)cdata;

    if (dndFileIcon == 0) {

        Pixmap dndFile  = XCreateBitmapFromData(display(),
                                                window(),
                                                (char *)file_bits, 
                                                16, 16);
        Pixmap dndFileM = XCreateBitmapFromData(display(),
                                                window(),
                                                (char *)file_m_bits, 
                                                16, 16);

        Pixmap dndDir = XCreateBitmapFromData(display(),
                                              window(),
                                              (char *)dir_bits, 
                                              16, 16);

        Pixmap dndDirM = XCreateBitmapFromData(display(),
                                               window(),
                                               (char *)dir_m_bits, 
                                               16, 16);


        args(XmNpixmap, dndFile)
            (XmNmask,   dndFileM)
            (XmNwidth,  16)
            (XmNheight, 16);

        dndFileIcon = XmCreateDragIcon(myTree->widget(), "dndFileIcon", args.getArgs(), args.count());

        args.reset();
        args(XmNpixmap, dndDir)
            (XmNmask,   dndDirM)
            (XmNwidth,  16)
            (XmNheight, 16);

        dndDirIcon = XmCreateDragIcon(myTree->widget(), "dndDirIcon", args.getArgs(), args.count());

        args.reset();
    }

    if ((int)(xtdcs->item->userData) & DIR_BIT) {
        args(XmNsourceCursorIcon, dndDirIcon);
        exportList[0] = dndDirAtom;
    } else {
        exportList[0] = dndFileAtom;
        args(XmNsourceCursorIcon, dndFileIcon);
    }

    exportList[0] = dndFileAtom;

    args(XmNexportTargets,    exportList)
        (XmNnumExportTargets, 1)
        (XmNblendModel,       XmBLEND_ALL)
        (XmNcursorBackground, myTree->background())
        (XmNcursorForeground, myTree->foreground())
        (XmNdragOperations,   XmDROP_MOVE)
        (XmNclientData,       (XtPointer)(xtdcs->item))
        (XmNconvertProc,      (XtPointer)ConvertProc);

    XmDragStart(myTree->widget(), xtdcs->event, args.getArgs(), args.count());

}

void Application::onTreeSelect(Widget, XtPointer, XtPointer cdata)
{
    XarmTreeItem *item = (XarmTreeItem *)cdata;

    getName(item);

    // Remove the trailing slash...

    int len = strlen(nameBuf);

    if (nameBuf[len - 1] == '/') nameBuf[len - 1] = '\0';

    len = (int)item->userData;

    fnText->setString(item->text);

    if (len & LINK_BIT)     tpText->setString("Link");
    else if (len & DIR_BIT) tpText->setString("Directory");
    else                    tpText->setString("File");

    struct stat statbuf;

    if (lstat(nameBuf, &statbuf) == 0) {
        char szBuffer[256];

        sprintf(szBuffer, "%d", statbuf.st_size);

        szText->setString(szBuffer);
    }
}

void Application::onTreeExpand(Widget, XtPointer, XtPointer cdata)
{
    XarmTreeItem *item = (XarmTreeItem *)cdata;

    if (item->isExpanded && !((int)(item->userData) & SCANNED_BIT)) {
        myTree->disableRedisplay();
        // Delete any fake entries...
        myTree->deleteItem(item->children);
        item->children = NULL;
        getName(item);
        readDir(nameBuf, item);
        myTree->enableRedisplay();
        item->userData = (XtPointer)((int)item->userData | SCANNED_BIT);
    }
}

void Application::onRCExpand(Widget, XtPointer, XtPointer)
{
    rcItem->isExpanded = !rcItem->isExpanded;
    onTreeExpand(NULL, NULL, (XtPointer)rcItem);
    myTree->refreshTree();
}

void Application::onRCSelect(Widget, XtPointer, XtPointer)
{
    onTreeSelect(NULL, NULL, (XtPointer)rcItem);
}

void Application::onTreeRightClick(Widget, XtPointer, XtPointer cdata)
{
    XarmTreeItem *item = (XarmTreeItem *)cdata;
    XButtonPressedEvent ev;

    int i1, i2;
    Window w1, w2;
    unsigned int bmask;
    int x_root, y_root;

    XQueryPointer(display(), window(), &w1, &w2, &x_root, &y_root, &i1, &i2, &bmask);

    ev.x_root = x_root;
    ev.y_root = y_root;

    rcmLabel->labelString(item->text);

    if ((int)item->userData & DIR_BIT) {
        if (item->isExpanded) ecButton->labelString("Collapse");
        else                  ecButton->labelString("Expand");
        ecButton->enable();
    } else ecButton->disable();

    rcItem = item;

    XmMenuPosition(*rcMenu, &ev);
    rcMenu->manage();
}

Application::Application(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext("treedemo", NULL, 0, argc_in_out, argv_in_out, fallbacks)
{

   XarmArg args;

   title("The Xarm Tree List");

   theApp = this;

   dndFileIcon = 0;
   nFT = nDT = 0;

   // install window manager message handler(s)
   Atom proto = addWMProtocol(XA_WM_DELETE_WINDOW);
   addWMProtocolCallback(this, &Application::Quit, this, proto);

   mainForm = new Form("mainForm", *this);

   args(XmNleftAttachment,   XmATTACH_FORM)
       (XmNtopAttachment,    XmATTACH_FORM)
       (XmNbottomAttachment, XmATTACH_FORM)
       (XmNleftOffset,       5)
       (XmNtopOffset,        5)
       (XmNbottomOffset,     5);

   treeFrame = new Frame(*mainForm, args, "treeFrame");
   treeForm  = new Form("treeForm", *treeFrame);

   args.reset();
   args(XmNleftAttachment,   XmATTACH_FORM)
       (XmNleftOffset,       0)
       (XmNrightAttachment,  XmATTACH_FORM)
       (XmNrightOffset,      0)
       (XmNtopAttachment,    XmATTACH_FORM)
       (XmNtopOffset,        0)
       (XmNbottomAttachment, XmATTACH_FORM)
       (XmNbottomOffset,     0)
       (XmNbackground, XmRString, "white", 5);

   // install window(s) into the application window
   myTree = new XarmTreeList(*treeForm, args, "myTree");

   pmDrive    = getPixmapFromData((const char **)drive_xpm);
   pmOpenDir  = getPixmapFromData((const char **)open_dir_xpm);
   pmCloseDir = getPixmapFromData((const char **)close_dir_xpm);
   pmFile     = getPixmapFromData((const char **)file_xpm);

   myTree->visibleRows(10);
   rootItem = myTree->addItemLast(NULL, "/ (root)", pmDrive, pmDrive);

   myTree->disableRedisplay();
   readDir("/", rootItem);
   myTree->enableRedisplay();

   myTree->expandTree(rootItem);

   myTree->manage();

   args.reset();
   args(XmNleftAttachment,   XmATTACH_WIDGET)
       (XmNleftWidget,       treeFrame)
       (XmNtopAttachment,    XmATTACH_FORM)
       (XmNrightAttachment,  XmATTACH_FORM)
       (XmNbottomAttachment, XmATTACH_FORM)
       (XmNleftOffset,       5)
       (XmNrightOffset,      5)
       (XmNtopOffset,        5)
       (XmNbottomOffset,     5);

   workFrame = new Frame(*mainForm, args, "workFrame");

   workForm = new Form("workForm", *workFrame);

   args.reset();
   args(XmNtopAttachment,   XmATTACH_FORM)
       (XmNtopOffset,       5)
       (XmNleftAttachment,  XmATTACH_FORM)
       (XmNleftOffset,      5)
       (XmNrightAttachment, XmATTACH_FORM)
       (XmNrightOffset,     5);

   Label *mainLabel = new Label(*workForm, args, "mainLabel");
   mainLabel->labelString("File Information");

   args.reset();
   args(XmNtopAttachment,   XmATTACH_WIDGET)
       (XmNtopWidget,       mainLabel)
       (XmNtopOffset,       10)
       (XmNleftAttachment,  XmATTACH_FORM)
       (XmNleftOffset,      5)
       (XmNrightAttachment, XmATTACH_FORM)
       (XmNrightOffset,     5);

   Separator *sep1 = new Separator(*workForm, args, "sep1");

   args.reset();
   args(XmNrightAttachment,       XmATTACH_FORM)
       (XmNrightOffset,           30)
       (XmNtopAttachment,         XmATTACH_WIDGET)
       (XmNtopWidget,             sep1)
       (XmNtopOffset,             10)
       (XmNeditable,              False)
       (XmNcursorPositionVisible, False)
       (XmNhighlightThickness,    0);

   fnText = new TextField(*workForm, args, "fnText");

   args.reset();
   args(XmNtopAttachment,    XmATTACH_OPPOSITE_WIDGET)
       (XmNtopWidget,        fnText)
       (XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET)
       (XmNbottomWidget,     fnText)
       (XmNleftAttachment,   XmATTACH_FORM)
       (XmNleftOffset,       20)
       (XmNrightAttachment,  XmATTACH_WIDGET)
       (XmNrightWidget,      fnText)
       (XmNrightOffset,      20)
       (XmNalignment,        XmALIGNMENT_BEGINNING);

   Label *fnLabel = new Label(*workForm, args, "fnLabel");
   fnLabel->labelString("Name:");

   args.reset();
   args(XmNrightAttachment,       XmATTACH_OPPOSITE_WIDGET)
       (XmNrightWidget,           fnText)
       (XmNleftAttachment,        XmATTACH_OPPOSITE_WIDGET)
       (XmNleftWidget,            fnText)
       (XmNtopAttachment,         XmATTACH_WIDGET)
       (XmNtopWidget,             fnText)
       (XmNtopOffset,             10)
       (XmNeditable,              False)
       (XmNcursorPositionVisible, False)
       (XmNhighlightThickness,    0);

   tpText = new TextField(*workForm, args, "tpText");

   args.reset();
   args(XmNtopAttachment,    XmATTACH_OPPOSITE_WIDGET)
       (XmNtopWidget,        tpText)
       (XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET)
       (XmNbottomWidget,     tpText)
       (XmNleftAttachment,   XmATTACH_FORM)
       (XmNleftOffset,       20)
       (XmNalignment,        XmALIGNMENT_BEGINNING);

   Label *tpLabel = new Label(*workForm, args, "tpLabel");
   tpLabel->labelString("Type:");

   args.reset();
   args(XmNrightAttachment,       XmATTACH_OPPOSITE_WIDGET)
       (XmNrightWidget,           tpText)
       (XmNleftAttachment,        XmATTACH_OPPOSITE_WIDGET)
       (XmNleftWidget,            tpText)
       (XmNtopAttachment,         XmATTACH_WIDGET)
       (XmNtopWidget,             tpText)
       (XmNtopOffset,             10)
       (XmNeditable,              False)
       (XmNcursorPositionVisible, False)
       (XmNhighlightThickness,    0);

   szText = new TextField(*workForm, args, "szText");

   args.reset();
   args(XmNtopAttachment,    XmATTACH_OPPOSITE_WIDGET)
       (XmNtopWidget,        szText)
       (XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET)
       (XmNbottomWidget,     szText)
       (XmNleftAttachment,   XmATTACH_FORM)
       (XmNleftOffset,       20)
       (XmNalignment,        XmALIGNMENT_BEGINNING);

   Label *szLabel = new Label(*workForm, args, "szLabel");
   szLabel->labelString("Size:");

   args.reset();
   args(XmNtopAttachment,   XmATTACH_WIDGET)
       (XmNtopWidget,       szLabel)
       (XmNtopOffset,       30)
       (XmNleftAttachment,  XmATTACH_FORM)
       (XmNleftOffset,      20)
       (XmNrightAttachment, XmATTACH_FORM)
       (XmNrightOffset,     20);

   Label *descLabel1 = new Label(*workForm, args, "descLabel");
   descLabel1->labelString("This is the XarmTreeList demo.");

   args.reset();
   args(XmNtopAttachment,   XmATTACH_WIDGET)
       (XmNtopWidget,       descLabel1)
       (XmNtopOffset,       5)
       (XmNleftAttachment,  XmATTACH_FORM)
       (XmNleftOffset,      20)
       (XmNrightAttachment, XmATTACH_FORM)
       (XmNrightOffset,     20)
       (XmNalignment,       XmALIGNMENT_BEGINNING);

   Label *descLabel2 = new Label(*workForm, args, "descLabel");
   descLabel2->labelString("Click the text of an entry to get information\n"
                           "on that entry. Click the icon or the Expand\n"
                           "Box of a directory entry to expand that\n"
                           "directory. For fun, try right-clicking on an\n"
                           "entry. And then try dragging an entry to the\n"
                           "trash can.");

   emptyTrash = loadPixmap(EmptyTrash_xpm);
   fullTrash  = loadPixmap(FullTrash_xpm);

   args.reset();
   args(XmNtopAttachment,   XmATTACH_WIDGET)
       (XmNtopWidget,       descLabel2)
       (XmNtopOffset,       10)
       (XmNleftAttachment,  XmATTACH_FORM)
       (XmNleftOffset,      5)
       (XmNrightAttachment, XmATTACH_FORM)
       (XmNrightOffset,     5)
       (XmNlabelType,       XmPIXMAP)
       (XmNlabelPixmap,     emptyTrash);

   trashCan = new Label(*workForm, args, "trashCan");

   args.reset();
   args(XmNtopAttachment,    XmATTACH_WIDGET)
       (XmNtopWidget,        trashCan)
       (XmNtopOffset,        10)
       (XmNleftAttachment,   XmATTACH_FORM)
       (XmNleftOffset,       30)
       (XmNrightAttachment,  XmATTACH_FORM)
       (XmNrightOffset,      30)
       (XmNbottomAttachment, XmATTACH_FORM)
       (XmNbottomOffset,     10)
       (XmNpacking,          XmPACK_COLUMN)
       (XmNnumColumns,       2)
       (XmNorientation,      XmVERTICAL)
       (XmNisAligned,        False);

   RowColumn *rc1 = new RowColumn(*workForm, args, "rc1");

   args.reset();
   args(XmNalignment, XmALIGNMENT_END);
   Label *nfLabel = new Label(*rc1, args, "nfLabel");
   nfLabel->labelString("Files trashed:");

   Label *ndLabel = new Label(*rc1, args, "ndLabel");
   ndLabel->labelString("Dirs trashed:");

   Label *lnLabel = new Label(*rc1, args, "lnLabel");
   lnLabel->labelString("Last item trashed:");

   args.reset();
   nfCount = new Label(*rc1, args, "nfCount");
   nfCount->labelString("0");

   ndCount = new Label(*rc1, args, "ndCount");
   ndCount->labelString("0");

   lnName = new Label(*rc1, args, "lnName");
   lnName->labelString("<NONE>");

   rc1->manage();

   // Create a right-click menu...

   rcMenu = new PopupMenu("rcMenu", *myTree);

   rcmLabel = new Label("rcmLabel", *rcMenu);
   rcmLabel->labelString("Unassigned");
   Separator *rcSep = new Separator("rcmSep", *rcMenu);
   ecButton = new PushButton("ecButton", *rcMenu);
   ecButton->labelString("Expand/Collapse");

   statButton = new PushButton("statButton", *rcMenu);
   statButton->labelString("Get File Info");

   treeForm->manage();
   treeFrame->manage();
   treeFrame->width(344);
   //   myTree->height(500);

   workForm->manage();
   workFrame->manage();

   mainForm->manage();

   addCallback(this, &Application::onTreeSelect,      myTree,     XaNselectCallback);
   addCallback(this, &Application::onTreeExpand,      myTree,     XaNexpandCallback);
   addCallback(this, &Application::onTreeRightClick,  myTree,     XaNrightClickCallback);
   addCallback(this, &Application::onStartDrag,       myTree,     XaNprocessDragCallback);

   addCallback(this, &Application::onRCExpand,        ecButton,   XmNactivateCallback);
   addCallback(this, &Application::onRCSelect,        statButton, XmNactivateCallback);

   dndFileAtom = XmInternAtom(display(), "XARM_TREE_FILE", False);
   dndDirAtom  = XmInternAtom(display(), "XARM_TREE_DIR", False);

   Atom importList[2] = { dndFileAtom, dndDirAtom };

   args.reset();
   args(XmNimportTargets,      importList)
       (XmNnumImportTargets,   2)
       (XmNdropSiteOperations, XmDROP_MOVE)
       (XmNdropProc,           (XtPointer)HandleDrop);

   XmDropSiteRegister(*trashCan, args.getArgs(), args.count());
}

void Application::dropItem(const XarmTreeItem *item)
{
    char nBuffer[256];

    if (item == NULL) {
      cout << "NULL item dropped!" << endl;
      return;
    }

    if ((int)(item->userData) & DIR_BIT) nDT++;
    else                                 nFT++;

    lnName->labelString(item->text);

    sprintf(nBuffer, "%d", nDT);
    ndCount->labelString(nBuffer);
    sprintf(nBuffer, "%d", nFT);
    nfCount->labelString(nBuffer);
    trashCan->labelPixmap(fullTrash);
}

#else

int main()
{
    cout << "Sorry, you don't have the Xbae Matrix widget support included." << endl;
    return 0;
}

#endif // XARM_HAS_XBAE

