/* $Id: CDESpinBox.h,v 1.1.1.1 2001/04/09 13:32:02 glgay Exp $ */
/*
 Copyright (C) 1997 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#if !defined(xarm_cdespinbox_h)
#define xarm_cdespinbox_h

#include <Dt/SpinBox.h>
#include <Xarm/Manager.h>

class SpinBoxClass : public ManagerClass {
 protected:
   SpinBoxClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return dtSpinBoxWidgetClass; }
   virtual _XtString className()      { return (_XtString) "dtSpinBox"; }

 public:
   /* callbacks */
   void modifyVerifyCallback(XtCallbackProc fp, XtPointer data = NULL)
                                    { XARM_SET_CALLBACK(DtNmodifyVerifyCallback); }
   void valueChangedCallback(XtCallbackProc fp, XtPointer data = NULL)
                                    { XARM_SET_CALLBACK(DtNvalueChangedCallback); }

   /* resources */
   void          arrowLayout(unsigned char val)      { XARM_SET_VALUE(DtNarrowLayout); }
   unsigned char arrowLayout() const                 { XARM_GET_VALUE(unsigned char, DtNarrowLayout); }
   void          arrowSize(Dimension val)            { XARM_SET_VALUE(DtNarrowSize); }
   Dimension     arrowSize() const                   { XARM_GET_VALUE(Dimension, DtNarrowSize); }
   void          initialDelay(unsigned int val)      { XARM_SET_VALUE(DtNinitialDelay); }
   unsigned int  initialDelay() const                { XARM_GET_VALUE(unsigned int, DtNinitialDelay); }
   void          repeatDelay(unsigned int val)       { XARM_SET_VALUE(DtNrepeatDelay); }
   unsigned int  repeatDelay() const                 { XARM_GET_VALUE(unsigned int, DtNrepeatDelay); }
   void          arrowSensitivity(unsigned char val) { XARM_SET_VALUE(DtNarrowSensitivity); }
   unsigned char arrowSensitivity() const            { XARM_GET_VALUE(unsigned char, DtNarrowSensitivity); }
   void          decimalPoints(short val)            { XARM_SET_VALUE(DtNdecimalPoints); }
   short         decimalPoints() const               { XARM_GET_VALUE(short, DtNdecimalPoints); }
   void          incrementValue(int val)             { XARM_SET_VALUE(DtNincrementValue); }
   int           incrementValue() const              { XARM_GET_VALUE(int, DtNincrementValue); }
   void          maximumValue(int val)               { XARM_SET_VALUE(DtNmaximumValue); }
   int           maximumValue() const                { XARM_GET_VALUE(int, DtNmaximumValue); }
   void          minimumValue(int val)               { XARM_SET_VALUE(DtNminimumValue); }
   int           minimumValue() const                { XARM_GET_VALUE(int, DtNminimumValue); }
   void          numValues(int val)                  { XARM_SET_VALUE(DtNnumValues); }
   int           numValues() const                   { XARM_GET_VALUE(int, DtNnumValues); }
   void          position(int val)                   { XARM_SET_VALUE(DtNposition); }
   int           position() const                    { XARM_GET_VALUE(int, DtNposition); }
   unsigned char spinBoxChildType() const            { XARM_GET_VALUE(unsigned char, DtNspinBoxChildType); }
   void          values(const XmStringTable val)     { XARM_SET_VALUE(DtNvalues); }
   XmStringTable values() const                      { XARM_GET_VALUE(XmStringTable, DtNvalues); }

   /* Extra functionality */
   void values(const char **, const int c);
   void add(const char *, int = 0);
   void del(int);
   void setItem(const char *);
};

typedef XarmFuncWidget<SpinBoxClass, DtCreateSpinBox, true> SpinBox;

#endif
