/* $Id: Display.h,v 1.1.1.1 2001/04/09 13:32:19 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_display_h)
#define xarm_display_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/ApplicationS.h>
#include <Xm/Display.h>

class DisplayClass;
typedef DisplayClass *WDisplay;
WDisplay getWDisplay(Display *);

class DisplayClass : public ApplicationShellClass {
 protected:
   friend WDisplay getWDisplay(Display *);
   DisplayClass() {} /* only a derived class can make this */

   virtual WidgetClass classPointer() { return xmDisplayClass; }
   virtual _XtString className()      { return (_XtString) "XmDisplay"; }
 public:
   /* resources */

#if defined(HAVE_DVB)
   /* well this seems to be missing in Motif 1.2.3 */
   void defaultVirtualBindings(const _XtString val)   { XARM_SET_VALUE(XmNdefaultVirtualBindings); }
   _XtString defaultVirtualBindings() const           { XARM_GET_VALUE(_XtString, XmNdefaultVirtualBindings); }
#endif

   void dragInitiatorProtocolStyle(unsigned char val) { XARM_SET_VALUE(XmNdragInitiatorProtocolStyle); }
   unsigned char dragInitiatorProtocolStyle() const   { XARM_GET_VALUE(unsigned char, XmNdragInitiatorProtocolStyle); }
   void dragReceiverProtocolStyle(unsigned char val)  { XARM_SET_VALUE(XmNdragReceiverProtocolStyle); }
   unsigned char dragReceiverProtocolStyle() const    { XARM_GET_VALUE(unsigned char, XmNdragReceiverProtocolStyle); }
};


#endif
