/* $Id: DragDrop.h,v 1.1.1.1 2001/04/09 13:32:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_dragdrop_h)
#define xarm_dragdrop_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Core.h>
#include <Xarm/Xarm.h>
#include <Xm/DragDrop.h>

#ifdef XARM_HAS_CDE
#include <Xarm/CDEdnd.h>
#endif

class DragContextClass : public CoreClass {
 protected:
   DragContextClass() {} /* only a derived class can make this */
 
   virtual WidgetClass classPointer() { return xmDragContextClass; }
   virtual _XtString className()      { return (_XtString) "XmDragContext"; }
 public:
   /* callbacks */
   void dragDropFinishCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                  { XARM_SET_CALLBACK(XmNdragDropFinishCallback); }
   void dragMotionCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                  { XARM_SET_CALLBACK(XmNdragMotionCallback); }
   void dropFinishCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                  { XARM_SET_CALLBACK(XmNdropFinishCallback); }
   void dropSiteEnterCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                  { XARM_SET_CALLBACK(XmNdropSiteEnterCallback); }
   void dropSiteLeaveCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                  { XARM_SET_CALLBACK(XmNdropSiteLeaveCallback); }
   void dropStartCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                  { XARM_SET_CALLBACK(XmNdropStartCallback); }
   void operationChangedCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                  { XARM_SET_CALLBACK(XmNoperationChangedCallback); }
   void topLevelEnterCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                  { XARM_SET_CALLBACK(XmNtopLevelEnterCallback); }
   void topLevelLeaveCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                  { XARM_SET_CALLBACK(XmNtopLevelLeaveCallback); }

   /* resources */
   unsigned char blendModel() const                 { XARM_GET_VALUE(unsigned char, XmNblendModel); }
   void clientData (XtPointer val)                  { XARM_SET_VALUE(XmNclientData); }
   XtPointer clientData() const                     { XARM_GET_VALUE(XtPointer, XmNclientData); }
   void convertProc(XtConvertSelectionIncrProc val) { XARM_SET_VALUE(XmNconvertProc); }
   XtConvertSelectionIncrProc convertProc() const   { XARM_GET_VALUE(XtConvertSelectionIncrProc, XmNconvertProc); }
   void cursorBackground(Pixel val)                 { XARM_SET_VALUE(XmNcursorBackground); }
   Pixel cursorBackground() const                   { XARM_GET_VALUE(Pixel, XmNcursorBackground); }
   void cursorForeground(Pixel val)                 { XARM_SET_VALUE(XmNcursorForeground); }
   Pixel cursorForeground() const                   { XARM_GET_VALUE(Pixel, XmNcursorForeground); }
   void exportTargets(Atom * val)                   { XARM_SET_VALUE(XmNexportTargets); }
   Atom *exportTargets() const                      { XARM_GET_VALUE(Atom *, XmNexportTargets); }
   void incremental(Boolean val)                    { XARM_SET_VALUE(XmNincrement); }
   Boolean incremental() const                      { XARM_GET_VALUE(Boolean, XmNincrement); }
   void invalidCursorForeground(Pixel val)          { XARM_SET_VALUE(XmNinvalidCursorForeground); }
   Pixel invalidCursorForeground() const            { XARM_GET_VALUE(Pixel, XmNinvalidCursorForeground); }
   void noneCursorForeground(Pixel val)             { XARM_SET_VALUE(XmNnoneCursorForeground); }
   Pixel noneCursorForeground() const               { XARM_GET_VALUE(Pixel, XmNnoneCursorForeground); }
   void numExportTargets(Cardinal val)              { XARM_SET_VALUE(XmNnumExportTargets); }
   Cardinal numExportTargets() const                { XARM_GET_VALUE(Cardinal, XmNnumExportTargets); }
   void operationCursorIcon(Widget val)             { XARM_SET_VALUE(XmNoperationCursorIcon); }
   Widget operationCursorIcon() const               { XARM_GET_VALUE(Widget, XmNoperationCursorIcon); }
   void sourceCursorIcon(Widget val)                { XARM_SET_VALUE(XmNsourceCursorIcon); }
   Widget sourceCursorIcon() const                  { XARM_GET_VALUE(Widget, XmNsourceCursorIcon); }
   void sourcePixmapIcon(Widget val)                { XARM_SET_VALUE(XmNsourcePixmapIcon); }
   Widget sourcePixmapIcon() const                  { XARM_GET_VALUE(Widget, XmNsourcePixmapIcon); }
   void stateCursorIcon(Widget val)                 { XARM_SET_VALUE(XmNstateCursorIcon); }
   Widget stateCursorIcon() const                   { XARM_GET_VALUE(Widget, XmNstateCursorIcon); }
   void validCursorForeground(Pixel val)            { XARM_SET_VALUE(XmNvalidCursorForeground); }
   Pixel validCursorForeground() const              { XARM_GET_VALUE(Pixel, XmNvalidCursorForeground); }

   // Additional functionality
   void cursorBackground(const char *val)           { XARM_SET_TYPED(XmNcursorBackground); }
   void cursorForeground(const char *val)           { XARM_SET_TYPED(XmNcursorForeground); }
   void invalidCursorForeground(const char *val)    { XARM_SET_TYPED(XmNinvalidCursorForeground); }
   void noneCursorForeground(const char *val)       { XARM_SET_TYPED(XmNnoneCursorForeground); }
   void validCursorForeground(const char *val)      { XARM_SET_TYPED(XmNvalidCursorForeground); }
   
};

class DragIconClass : public _ObjectClass {
 protected:
   DragIconClass() {}     

   virtual WidgetClass classPointer() { return xmDragIconObjectClass; }
   virtual _XtString className() { return (_XtString) "XmDragIcon"; }
 public:
   /* resources */
   void attachment(unsigned char val)  { XARM_SET_VALUE(XmNattachment); }
   unsigned char attachment() const    { XARM_GET_VALUE(unsigned char, XmNattachment); }
   void depth(int val)                 { XARM_SET_VALUE(XmNdepth); }
   int depth() const                   { XARM_GET_VALUE(int, XmNdepth); }
   void height(Dimension val)          { XARM_SET_VALUE(XmNheight); }
   Dimension height() const            { XARM_GET_VALUE(Dimension, XmNheight); }
   void hotX(Position val)             { XARM_SET_VALUE(XmNhotX); }
   Position hotX() const               { XARM_GET_VALUE(Position, XmNhotX); }
   void hotY(Position val)             { XARM_SET_VALUE(XmNhotY); }
   Position hotY() const               { XARM_GET_VALUE(Position, XmNhotY); }
   void mask(Pixmap val)               { XARM_SET_VALUE(XmNmask); }
   Pixmap mask() const                 { XARM_GET_VALUE(Pixmap, XmNmask); }
   void offsetX(Position val)          { XARM_SET_VALUE(XmNoffsetX); }
   Position offsetX() const            { XARM_GET_VALUE(Position, XmNoffsetX); }
   void offsetY(Position val)          { XARM_SET_VALUE(XmNoffsetY); }
   Position offsetY() const            { XARM_GET_VALUE(Position, XmNoffsetY); }
   void pixmap(Pixmap val)             { XARM_SET_VALUE(XmNpixmap); }
   Pixmap pixmap() const               { XARM_GET_VALUE(Pixmap, XmNpixmap); }
   void width(Dimension val)           { XARM_SET_VALUE(XmNwidth); }
   Dimension width() const             { XARM_GET_VALUE(Dimension, XmNwidth); }
};

class DropTransferClass : public _ObjectClass 
{
 protected:
   DropTransferClass() {}
 public:
   /* resources */
   XmDropTransferEntryRec *dropTransfers() const   { XARM_GET_VALUE(XmDropTransferEntryRec *, XmNdropTransfers); }
   void incremental(Boolean val)                   { XARM_SET_VALUE(XmNincremental); }
   Boolean incremental() const                     { XARM_GET_VALUE(Boolean, XmNincremental); }
   void numDropTransfers(Cardinal val)             { XARM_SET_VALUE(XmNnumDropTransfers); }
   Cardinal numDropTransfers() const               { XARM_GET_VALUE(Cardinal, XmNnumDropTransfers); }
   void transferProc(XtSelectionCallbackProc val)  { XARM_SET_VALUE(XmNtransferProc); }
   XtSelectionCallbackProc transferProc() const    { XARM_GET_VALUE(XtSelectionCallbackProc, XmNtransferProc); }
   void transferStatus(unsigned char val)          { XARM_SET_VALUE(XmNtransferStatus); }
   unsigned char transferStatus() const            { XARM_GET_VALUE(unsigned char, XmNtransferStatus); }
};

#endif
