/* $Id: Scale.h,v 1.1.1.1 2001/04/09 13:33:08 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_scale_h)
#define xarm_scale_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>
#include <Xm/Scale.h>

class ScaleClass : public ManagerClass {
 protected:
   ScaleClass() {}
   virtual WidgetClass classPointer() { return xmScaleWidgetClass; }
   virtual _XtString className()      { return (_XtString) "XmScale"; }
 public:
   /* callbacks */
   void dragCallback(XtCallbackProc fp, XtPointer data = NULL) { XARM_SET_CALLBACK(XmNdragCallback); }
   void valueChangedCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                       { XARM_SET_CALLBACK(XmNvalueChangedCallback); }

   /* resources */
   void decimalPoints(short val)               { XARM_SET_VALUE(XmNdecimalPoints); }
   short decimalPoints() const                 { XARM_GET_VALUE(short, XmNdecimalPoints); }
   void fontList(const XmFontList val)         { XARM_SET_VALUE(XmNfontList); }
   XmFontList fontList() const                 { XARM_GET_VALUE(XmFontList, XmNfontList); }
   void highlightOnEnter(Boolean val)          { XARM_SET_VALUE(XmNhighlightOnEnter); }
   Boolean highlightOnEnter() const            { XARM_GET_VALUE(Boolean, XmNhighlightOnEnter); }
   void highlightThickness(Dimension val)      { XARM_SET_VALUE(XmNhighlightThickness); }
   Dimension highlightThickness() const        { XARM_GET_VALUE(Dimension, XmNhighlightThickness); }
   void maximum(int val)                       { XARM_SET_VALUE(XmNmaximum); }
   int maximum() const                         { XARM_GET_VALUE(int, XmNmaximum); }
   void minimum(int val)                       { XARM_SET_VALUE(XmNminimum); }
   int minimum() const                         { XARM_GET_VALUE(int, XmNminimum); }
   void orientation(unsigned char val)         { XARM_SET_VALUE(XmNorientation); }
   unsigned char orientation() const           { XARM_GET_VALUE(unsigned char, XmNorientation); }
   void processingDirection(unsigned char val) { XARM_SET_VALUE(XmNprocessingDirection); }
   unsigned char processingDirection() const   { XARM_GET_VALUE(unsigned char, XmNprocessingDirection); }
   void scaleHeight(Dimension val)             { XARM_SET_VALUE(XmNscaleHeight); }
   Dimension scaleHeight() const               { XARM_GET_VALUE(Dimension, XmNscaleHeight); }
   void scaleMultiple(int val)                 { XARM_SET_VALUE(XmNscaleMultiple); }
   int scaleMultiple() const                   { XARM_GET_VALUE(int, XmNscaleMultiple); }
   void scaleWidth(Dimension val)              { XARM_SET_VALUE(XmNscaleWidth); }
   Dimension scaleWidth() const                { XARM_GET_VALUE(Dimension, XmNscaleWidth); }
   void showValue(Boolean val)                 { XARM_SET_VALUE(XmNshowValue); }
   Boolean showValue() const                   { XARM_GET_VALUE(Boolean, XmNshowValue); }
   void titleString(const char *str)           { XARM_SET_STRING(XmNtitleString); }
   char *titleString() const                   { XARM_GET_STRING(XmNtitleString); }
   void value(int val)                         { XARM_SET_VALUE(XmNvalue); }
   int value() const                           { XARM_GET_VALUE(int, XmNvalue); }
};

typedef XarmRawWidget<ScaleClass, false> Scale;

#endif
