#ifndef INCL_DDRAW_H
#define INCL_DDRAW_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/gadget.h>
#include <Xclasses/gfx_object.h>

#define LOCK_BORDER		0
#define LOCK_NOBORDER	1

class Ddraw
{
	friend class pDdraw;

	class pDdraw *p;
	
public:

	Ddraw(void);
	Ddraw(gadget *);
	~Ddraw();
	
	int BorderSize(int newsize); // returns old size
	int RealSize(void);			 // returns real bordersize
	void KeyBorder(void);
	void NoKeyBorder(void);
	void StripesMark(void);
	void SolidMark(void);

	void borderlocked(class gadget *g,int x,int y,int w,int h,int flags=LOCK_BORDER);

	int textheight(class gadget *g,char *txt,XFontStruct *font);	// total height in pixel
	int textlength(class gadget *g,char *txt,XFontStruct *font);	// max length in pixel
	int textheight(class gadget *g,char *txt) 
	  	{ return textheight(g,txt,g->gg_font()); };
	int textlength(class gadget *g,char *txt) 
	  	{ return textlength(g,txt,g->gg_font()); };	
	
	void borderUp(class gadget *g,int x,int y,int w,int h);
	void borderDown(class gadget *g,int x,int y,int w,int h);
	void borderEmboss(class gadget *g,int x,int y,int w,int h);
	void borderUpFill(class gadget *g,int x,int y,int w,int h);
	void borderDownFill(class gadget *g,int x,int y,int w,int h);
	void borderEmbossFill(class gadget *g,int x,int y,int w,int h);
	void borderUpShineFill(class gadget *g,int x,int y,int w,int h);

	void bordertext(class gadget *g,int x,int y,int w,int h,char *txt,int adjust,XFontStruct *font);	
	void bordertext(class gadget *g,int x,int y,int w,int h,char *txt,int adjust=(ADJUST_CENTER|ADJUST_MIDDLE))
		{ bordertext(g,x,y,w,h,txt,adjust,g->gg_font()); };
	
	void borderselectedtext(class gadget *g,int x,int y,int w,int h,char *txt,int adjust,XFontStruct *font);	
	void borderselectedtext(class gadget *g,int x,int y,int w,int h,char *txt,int adjust=(ADJUST_CENTER|ADJUST_MIDDLE))
		{ borderselectedtext(g,x,y,w,h,txt,adjust,g->gg_font()); };

	void borderlockedtext(class gadget *g,int x,int y,int w,int h,char *txt,int adjust,XFontStruct *font);	
	void borderlockedtext(class gadget *g,int x,int y,int w,int h,char *txt,int adjust=(ADJUST_CENTER|ADJUST_MIDDLE))
		{ borderlockedtext(g,x,y,w,h,txt,adjust,g->gg_font()); };
	
	void bordermark(class gadget *g,int x,int y,int w,int h);
	void borderunmark(class gadget *g,int x,int y,int w,int h);
	
};

#endif
