/****************************************************************************/
/*   xmUsrDlg.C                                                             */
/****************************************************************************/
/*                                                                          */
/*   Copyright (c) 1992, 1993, 1994 Bernhard Strassl                        */
/*       Vienna User Interface Group                                        */
/*       Institute for Applied Computer Science and Information Systems     */
/*       University of Vienna, Austria                                      */
/*                                                                          */
/*   See file COPYRIGHT in this directory for details. If this file is      */
/*   missing please mail to xmplus@ani.univie.ac.at                         */
/****************************************************************************/

#include <stdarg.h>
#include <strstream.h>
#include <iostream.h>
#include <fstream.h>

extern ofstream errlog;

#include <xmObject.h>

#define _freeStringList(x) \
	if(x) \
	{	for(	int _freeStringListIt = 0; \
			x[_freeStringListIt]; \
			_freeStringListIt++) \
			delete x[_freeStringListIt]; \
		delete x; \
	} \
	x = NULL;


char* XmImageDir = "./";
char* bmp_file_errors[] = { "open failed" , "invalid data", "no memory" };

Pixmap _createXmPixmap(char* wname, int w, int h)
{
	return(0);
}

extern void genericCallback(Widget, XtPointer, XtPointer);

XmDialogPane::~XmDialogPane()
{
	for(int i = 0; i < controlCount; i++)
	{	controls[i]->resetParent();
		delete controls[i];
	}
}

void XmDialogPane::getFocus(Widget)
{
}

int XmDialogPane::controlIndex(XmControl* aControl)
{
	for(int i = 0; i < controlCount; i++)
	{	if(controls[i] == aControl)
			return(i);
	}
	return(-1);
}

XmControl* XmDialogPane::findControl(ctrlType t, char* n, bool warn)
{
	ctrlType ct;

	for(int i = 0; i < controlCount; i++)
	{	ct = controls[i]->controlType();
		if(!strcmp(controls[i]->wname, n))
		{	if(ct == t)
				return(controls[i]);
			errlog << "class xmDialogPane: Error - invalid control type for " << n << " !\n";
			return(NULL);
		}
		XmControl* aControl;
		if(((ct == GroupBox || ct == PaneArea) && (aControl = ((XmGroupBox* )controls[i])->findControl(t, n, FALSE))) ||
			(ct == Pane && (aControl = ((XmPane* )controls[i])->getControl(t, n))))
			return(aControl);
	}
	if(warn)	// explain the following core dump...
		errlog << "class xmDialogPane: Error - control with name " << n << " not found !\n";
	return(NULL);
}

XmGroupBox* XmDialogPane::nextGroup(int& ndx)
{
	while(ndx < controlCount)
	{	if(controls[ndx]->controlType() == GroupBox)
			return((XmGroupBox* )controls[ndx++]);
		ndx++;
	}
	return(NULL);
}

bool XmDialogPane::add(XmControl* aControl, XmObject* rec, cbProc code, void* cl_data)
{
	XmGroupBox* g;
	int ndx = 0;

	while(g = nextGroup(ndx))
	{	if(g->parentFor(aControl))
			break;
	}
	if(g)
		return(g->addAbs(aControl, rec, code, cl_data));
	else
	{
//#ifdef TCL
		aControl->handle()->setParent(handle());
//#endif
		if(aControl->createControl(this))
			controls[controlCount++] = (XmControl* )aControl->getBase();
		else
			return(FALSE);
		if(aControl->isA(RadioButton))
		{	XmRadioButton* r = (XmRadioButton* )aControl;
			if(curRadio)
				curRadio->chainTo(r);
			curRadio = r;
		}
		if(rec && validProc(code))
			aControl->setCallback(NULL, rec, code, TRUE, cl_data);
	}
	return(TRUE);
}

bool XmDialogPane::removeControl(int ndx)
{
	if(ndx < 0 || ndx >= controlCount || !controls[ndx]->destroy())
		return(FALSE);
	controls[ndx]->resetParent();
	controlCount--;
	int i = ndx;
	while(i < controlCount)
	{	controls[i] = controls[i + 1];
		i++;
	}
	return(TRUE);
}

bool XmDialogPane::remove(char* n)
{
	int ndx = -1;

	for(int i = 0; i < controlCount; i++)
	{	if(!strcmp(controls[i]->wname, n))
		{	ndx = i;
			break;
		}
	}
	return(removeControl(i));
}

XmControl* XmDialogPane::find(char* n)
{
	for(int i = 0; i < controlCount; i++)
	{	if(!strcmp(controls[i]->wname, n))
			return(controls[i]);
	}
	return(NULL);
}


// Base class for user defined dialogs //////////////////////////


XmUserDialog::XmUserDialog(char* n, XmObject* par, xmStyle s) : XmDialog(n, par, s)
{
	initDialog(n, par, s);
}

XmUserDialog::XmUserDialog(char* n, XmObject* par, XmManager* mgr, xmStyle s) : XmDialog(n, par, s)
{
	manager = mgr;
	manager->addObject(this, DialogWindow);
	initDialog(n, par, s);
}

XmUserDialog::~XmUserDialog()
{
	if(manager)
		manager->removeObject(this);
}

void XmUserDialog::initDialog(char* n, XmObject* par, xmStyle s)
{
	ix = iy = iw = ih = 0;
#ifdef __OLDGNU__
	delete wid;	// when using gcc only the default constr 
	delete wname;	// of XmObject is called. so let's do it
	init(n, par);	// once more...
#endif
	basePtr = (XmObject* )((void* )this);		// override the base pointer !

	wid->setToplevel();	// for the same reason as above...
	if(par)
	{	wid->cmd(RCI_CREATE, RCI_TOPLEVEL);
		wid->arg() = par->handle()->getId();
		wid->arg() = (unsigned long)s;
		wid->execCreate();
	}
	else
		App->newMainWindow(this, n, 0, 0, s);
	setLabelAndMode(n);
	destroyOnDelete();
}

void XmUserDialog::getFocusCb(void* w)
{
	getFocus((Widget )w);
}

void XmUserDialog::destroyCb(void* w)
{
	if(magic == MAGIC_OBJECT_CONST && wid == (Widget )w)
	{	wid = NULL;
		delete this;
	}
}

bool XmUserDialog::run(char*, char*)
{
// run modal, args are confirm and cancel control
	return(FALSE);
}

bool XmUserDialog::realize()
{
	if(wid && wid->isOk())
	{	int x = 0, y = 0, w = 0, h = 0;
		if(initWindowSize(x, y, w, h))
		{	ix = x; iy = y; iw = w; ih = h;
		}
		if(ix || iy)
		{	wid->cmd(RCI_CONFIG, RCI_LOCATION);
			wid->arg() = (int)ix;
			wid->arg() = (int)iy;
			wid->execCmd();
		}
		if(iw || ih)
		{	wid->cmd(RCI_CONFIG, RCI_SIZE);
			wid->arg() = (int)iw;
			wid->arg() = (int)ih;
			wid->execCmd();
		}
		return(XmObject::realize());
	}
	return(FALSE);
}

bool XmUserDialog::hide()
{
	if(!wid)
		return(FALSE);
	if(dlgStyle & XmSpopup)
	{	
		return(TRUE);
	}
	return(XmObject::hide());
}

bool XmUserDialog::show()
{
	if(!wid)
		return(FALSE);
	if(dlgStyle & XmSpopup)
	{	
		return(TRUE);
	}
	return(XmObject::show());
}

bool XmUserDialog::setLabel(char* txt)
{
	Arg a;

	if(!wid)
		return(FALSE);
	wid->cmd(RCI_CONFIG, RCI_LABEL);
	wid->arg() = txt;
	return(wid->execCmd());
}

bool XmUserDialog::setFocus(char*)			{ return(FALSE); }

bool XmUserDialog::setDefaultButton(char* bName)
{
	return(FALSE); 
}

#define do_single_arg(func) \
	XmControl* aControl; \
	if(aControl = find(first)) \
		aControl-> func (); \
	return(aControl ? TRUE : FALSE);

#define do_varargs(func) \
	char* aName = first; \
	XmControl* aControl; \
	va_list ap; \
	va_start(ap, first); \
	do \
	{	if(aControl = find(aName)) \
			aControl-> func (); \
	} \
	while((aName = va_arg(ap, char *)) != (char *)0); \
	va_end(ap); \
	return(TRUE);

#define do_ptrs(func) \
	char* aName = *list; \
	XmControl* aControl; \
	while(aName = *list++) \
	{	if(aControl = find(aName)) \
			aControl-> func (); \
	} \
	return(TRUE);

bool XmDialogPane::disable(char** list)
{
	do_ptrs( disable )
}

bool XmDialogPane::disable(char* first, ...)
{
#ifndef NO_VARARGS
	do_varargs( disable )
#else
	do_single_arg( disable )
#endif
}

bool XmDialogPane::enable(char** list)
{
	do_ptrs( enable )
}

bool XmDialogPane::enable(char* first, ...)
{
#ifndef NO_VARARGS
	do_varargs( enable )
#else
	do_single_arg( enable )
#endif
}

bool XmDialogPane::hideAll(char** list)
{
	do_ptrs( hide )
}

bool XmDialogPane::hideAll(char* first, ...)
{
#ifndef NO_VARARGS
	do_varargs( hide )
#else
	do_single_arg( hide )
#endif
}

bool XmDialogPane::showAll(char** list)
{
	do_ptrs( show )
}

bool XmDialogPane::showAll(char* first, ...)
{
#ifndef NO_VARARGS
	do_varargs( show )
#else
	do_single_arg( show )
#endif
}

// Controls /////////////////////////////////////////////

XmControl::XmControl(char* n, int x, int y, int w, int h, xmStyle s) : XmObject(n, (XmObject* )NULL)
{
	cx = x; cy = y; cw = w; ch = h;
	style = s;
}

XmControl::~XmControl()
{
	if(parent && parent->asDialogPane())
		parent->asDialogPane()->remove(this);
}

bool XmControl::setCbFor(Widget w, char* cbName, XmObject* rec, cbProc code, bool sr, void* cl_data)
{
	if(!rec || !(cbName || defaultCallback()))
	{	errlog << "xmControl: " << wname << " - invalid callback parameters, ignoring request...\n";
		return(FALSE);
	}
	if(!cbName)
		cbName = defaultCallback();
	if(hookedCb() && !strcmp(cbName, hookedCb()) && rec != this)
	{	userData.receiver = rec->getBase();
		userData.callback = code;
		userData.client_data = (cl_data == CB_OBJ_PTR) ? this : cl_data;
	}
	else 
		XmObject::setCbFor(w, cbName, rec, code, sr, (cl_data == CB_OBJ_PTR) ? this : cl_data);
	return(TRUE);
}

void XmControl::makeRelativeTo(XmGroupBox* aGroup)
{
	cx -= aGroup->cx;
	cy -= aGroup->cy;
}

void XmControl::initTabstop(bool force)
{
}

char* XmControl::currentLabel()
{
	char* aStr = wname;

	if(hasArg("Text"))
		aStr = (char*)wargs[argIndex("Text")].value;
	return(aStr);
}

void XmControl::setLabelAndMnemonic()
{
	;	// does nothing, see createControl functions...
}


XmUserDialog* XmControl::getDialog()
{
	return(parent->asDialog());
}

bool XmControl::move(int nx, int ny)
{
	cx = nx;
	cy = ny;
	if(wid && wid->getParent())
		return(XmObject::move(cx, cy));
	return(TRUE);
}

bool XmControl::resize(int nw, int nh)
{
	cw = nw;
	ch = nh;
	if(wid && wid->getParent())
		return(XmObject::resize(cw, ch));
	return(TRUE);
}

bool XmControl::reframe(int nx, int ny, int nw, int nh)
{
	cx = nx;
	cy = ny;
	cw = nw;
	ch = nh;
	if(wid && wid->getParent())
		return(XmObject::reframe(cx, cy, cw, ch));
	return(TRUE);
}

bool XmControl::getFrame(int& fx, int& fy, int& fw, int& fh)
{
	if(wid->isOk())
		return(XmObject::getFrame(fx, fy, fw, fh));
	else
	{	fx = cx;
		fy = cy;
		fw = cw;
		fh = ch;
	}
	return(TRUE);
}

bool XmControl::updateDimensions()
{
	int ix, iy, iw, ih;

	if(wid->isOk())
	{	if(XmObject::getFrame(ix, iy, iw, ih))
		{	cx = ix; cy = iy; cw = iw; ch = ih;
			return(TRUE);
		}
	}
	return(FALSE);
}

XmControl* XmControl::setText(char* aStr)
{
	if(wid->isOk())
	{	int majorOp = RCI_CONFIG, minorOp = RCI_LABEL;

		if(isAn(Edit) || isA(StaticText))
		{	majorOp = RCI_SETVAL;
			minorOp = RCI_TEXT;
		}
		wid->cmd(majorOp, minorOp);
		wid->arg() = aStr;
		if(wid->execCmd())
		{	RciArg* a = new RciArg;
			*a = aStr;
			wid->setAnswer(a);
		}
	}
	else
		addArg("text", (XtArgVal)_mkstr(aStr));
	return(this);
}

XmControl* XmControl::setFont(char* aStr)
{
	return(this);
}

char* _control_get_text_buffer = NULL;

char* XmControl::getText()
{
	char* curTxt = NULL;

	if(wid->isOk())
	{	int majorOp = RCI_GETCONFIG, minorOp = RCI_LABEL;

		if(isAn(Edit) || isA(StaticText) || isA(ComboBox))
		{	majorOp = RCI_GETVAL;
			minorOp = RCI_TEXT;
		}
		wid->cmd(majorOp, minorOp);
		delete _control_get_text_buffer;
		if(wid->hasAutoAnswer() || wid->execValRequest())
			_control_get_text_buffer = curTxt = _mkstr(wid->answer(0));
		else
			_control_get_text_buffer = curTxt = NULL;
	}
	else
		curTxt = wid->getText();
	return(curTxt);
}

XmControl* XmControl::setImage(Pixmap aPixmap)
{
	return(this);
}

XmControl* XmControl::setFocus()
{
	return(this);
}

XmControl* XmControl::disable()
{
	if(wid->isOk())
	{	wid->cmd(RCI_CONFIG, RCI_SENSITIVE);
		wid->arg() = 0;
		wid->execCmd();
	}
	return(this);
}

XmControl* XmControl::enable()
{
	if(wid->isOk())
	{	wid->cmd(RCI_CONFIG, RCI_SENSITIVE);
		wid->arg() = 1;
		wid->execCmd();
	}
	return(this);
}

#define rci_create_control(control_type) \
\
	wid->cmd(RCI_CREATE, control_type); \
	wid->arg() = par->handle()->getId(); \
	wid->arg() = (int)cx; \
	wid->arg() = (int)cy; \
	wid->arg() = (int)cw; \
	wid->arg() = (int)ch; \
	wid->arg() = (unsigned long)style; \
	if(wid->execCreate()) \
	{	wid->processArgs(wargs, wargcount); \
		wargcount = 0; \
	}


bool XmGroupBox::createControl(XmControlPane* par)
{
//	debugPtr = basePtr;

	rci_create_control(RCI_GROUPBOX);

	wargcount = 0;
	parent = par->asObject();
	return(wid->isOk() ? TRUE : FALSE);
}

void XmGroupBox::getFocusCb(void* w)
{
	getFocus((Widget )w);
}

bool XmGroupBox::parentFor(XmControl* c)
{
	if(c->cx > cx && c->cx < cx + cw && c->cy > cy && c->cy < cy + ch)
		return(TRUE);
	return(FALSE);
}

bool XmGroupBox::addAbs(XmControl* c, XmObject* rec, cbProc cb, void* cd)	
{
	c->makeRelativeTo(this);
	return(XmDialogPane::add(c, rec, cb, cd));
}

bool XmGroupBox::remove(char* n)
{
	return(XmDialogPane::remove(n));
}


bool XmPane::createControl(XmControlPane* par)
{
	rci_create_control(RCI_GROUPBOX);

	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmPane::setContents(XmControl* c, XmObject* rec, cbProc cb)	
{
	if(contents)
	{	if(!contents->destroy())
			return(FALSE);
	}
	contents = NULL;
	if(c)
	{	if(!c->createControl(this))
			return(FALSE);
		contents = c;		// (XmControl* )aControl->asObjPtr();
		if(rec && c->defaultCallback())
			c->setCallback(c->defaultCallback(), rec, cb, TRUE, (void* )c);
		c->userData.receiver = (rec) ? rec->getBase() : rec;
		c->userData.callback = cb;
		if(handle() && isObjRealized(handle()))
			c->realize();
	}
	return(TRUE);
}

bool XmPane::changeLabel(char* txt)
{
	return(FALSE);
}


bool XmPaneArea::createControl(XmControlPane* par)
{
	rci_create_control(RCI_GROUPBOX);

	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

void XmPaneArea::changed(void*)
{
}

bool XmPaneArea::add(XmControl* aControl, XmObject* rec, cbProc p, void* cd)
{
	if(XmDialogPane::add(aControl, rec, p, cd))
	{	subPaneCount++;

		; // do some layout here...

		return(TRUE);
	}
	return(FALSE);
}

bool XmPaneArea::remove(char* name)
{
	if(!XmDialogPane::remove(name))
		return(FALSE);
	subPaneCount--;
	return(TRUE);
}

bool XmPaneArea::addSubpane(XmControl* aControl, char* title, XmObject* rec, cbProc p)
{
	int nh = aControl->ch ? aControl->ch : (title ? 30 : 10);
	XmPane* aPane;

	if(aControl->controlType() == Edit)
		aControl->changeStyle(aControl->style | XmSmultiLine);	// ensure multi-line...

	if(title)
	{	char namebuf[100];
		strcpy(namebuf, aControl->getName());
		strcat(namebuf, "Pane");
		aPane = new XmPane(namebuf, 0, aControl->cy, cw, nh);
		aPane->setText(title);
		if(add(aPane))
		{	return(aPane->setContents(aControl, rec, p));
		}
		delete aPane;
		return(FALSE);
	}
	aControl->resize(cw, nh);
	if(add(aControl, rec, p))
		return(TRUE);
	return(FALSE);
}

bool XmPaneArea::changeSubpaneLabel(char* name, char* txt)
{
	char namebuf[100];
	XmPane* aPane;

	strcpy(namebuf, name);
	strcat(namebuf, "Pane");
	if(((aPane = (XmPane* )find(name)) || (aPane = (XmPane* )find(namebuf))) && aPane->controlType() == Pane)
		return(aPane->changeLabel(txt));
	errlog << "xmPaneArea: change label error - no pane " << namebuf << " found (" << /* hex(long(aPane)) << */ ")\n";
	return(FALSE);
}


bool XmToolBar::createControl(XmControlPane* par)
{
	rci_create_control(RCI_GROUPBOX);

	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmToolBar::add(XmControl* c, XmObject* rec, cbProc cb, void* cd)	
{
	if(c->isAn(Edit))
		c->changeStyle(c->getStyle() | XmStabStop);
	return(XmGroupBox::add(c, rec, cb, cd));
}

bool XmStatusBar::createControl(XmControlPane* par)
{
	return(FALSE);		// not implemented yet... (use a bottom toolbar instead!)
}

bool XmStatusBar::add(XmControl* aControl, XmObject* anObj, cbProc aProc, void* cl_data)
{
	XmControl* lastControl = controls[controlCount - 1];

	if(aControl->isAn(Edit))
		aControl->changeStyle(aControl->getStyle() | XmStabStop);
	if(XmGroupBox::add(aControl, anObj, aProc, cl_data))
	{	// lastControl->resize(...);  // should ensure correct layout...
		return(TRUE);
	}
	return(FALSE);
}

bool XmStatusBar::remove(char* aName)
{
	XmControl* prevControl, * aControl = find(aName);
	int ndx = controlIndex(aControl);

	if(!aControl)
		return(FALSE);
	prevControl = controls[ndx - 1];
	if(XmGroupBox::remove(aName))
	{	// prevControl->resize(...);  // should ensure correct layout...
		return(TRUE);
	}
	return(FALSE);
}

bool XmStatusBar::setMessage(char* msg)
{
	return(statusLine ? (statusLine->setText(msg) ? TRUE : FALSE) : FALSE);
}


bool XmStaticText::createControl(XmControlPane* par)
{
	rci_create_control(RCI_STATICTEXT);

	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmStaticImage::createControl(XmControlPane* par)
{
	rci_create_control(RCI_STATICIMAGE);

	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmPushButton::createControl(XmControlPane* par)
{
	rci_create_control(RCI_PUSHBTN);

	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmCheckBox::createControl(XmControlPane* par)
{
	rci_create_control(RCI_CHECKBOX);

	RciArg* a = new RciArg;
	*a = (int)0;
	wid->setAnswer(a);
	wid->setAutoAnswer();
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmCheckBox::setState(bool newState)
{
	bool oldState = getState();

	if(oldState != newState)
	{	if(wid->isOk())
		{	wid->cmd(RCI_SETVAL, RCI_STATE);
			wid->arg() = (int)newState;
			if(wid->execCmd())
			{	RciArg* a = new RciArg;
				*a = (int)newState;
				wid->setAnswer(a);
			}
		}
		else
			changeArg("State", long(newState));
	}
	return(oldState);
}

bool XmCheckBox::getState()
{
	int state = 0;
	if(wid->isOk())
	{	wid->cmd(RCI_GETVAL, RCI_STATE);
		if(wid->hasAutoAnswer() || wid->execValRequest())
			state = wid->answer(0);
	}
	else if(hasArg("State"))
		state = (int)wargs[argIndex("State")].value;
	return(state ? TRUE : FALSE);
}

bool XmRadioButton::createControl(XmControlPane* par)
{
	bool initState = XmCheckBox::getState();

	rci_create_control(RCI_RADIOBTN);

	if(initState)
		XmCheckBox::setState(TRUE);

	wid->setAutoAnswer();
	wargcount = 0;
	parent = par->asObject();
	setCallback(this, CBK(XmRadioButton, selected));
	return(wid ? TRUE : FALSE);
}

void XmRadioButton::selected(void* cd)
{
	if(getState() && userData.receiver && validProc(userData.callback))
		genericCallback(wid, (XtPointer )&userData, (XtPointer )cd);
}

// let's assume that the following two functions are unused in
// this implementation - the RCI server should handle the automatical
// deselection of the other buttons in a group....

void XmRadioButton::reset(bool direction)
{
}

bool XmRadioButton::setState(bool newState)
{
	return(XmCheckBox::setState(newState));
}

XmRadioButton* XmRadioButton::getSelected()
{
	if(getState())
		return(this);
	XmRadioButton* aButton;
	if(	(next && (aButton = next->getSelected())) ||
		(prev && (aButton = prev->getSelected())))
		return(aButton);
	return(NULL);
}

#include <math.h>

bool XmValuator::createControl(XmControlPane* par)
{
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

int XmValuator::f2i(float f)
{
	return(int(f * pow(10, decimals)));
}

float XmValuator::i2f(int i)
{
	float f = i;
	return(f / pow(10, decimals));
}

bool XmValuator::setOrientation(bool horiz)
{
	return(FALSE);
}

bool XmValuator::setDirection(bool begToEnd)
{
	return(FALSE);
}

short XmValuator::setDecimalPoints(short d)
{
	return(0);
}

void XmValuator::displayValue(bool yes)
{
}

XmControl* XmValuator::setText(char* txt)
{
	return(this);
}

XmControl* XmValuator::setRange(int from, int to)
{
	return(this);
}

XmControl* XmValuator::setValue(int val)
{
	return(this);
}

int XmValuator::getValue()
{
	return(0);
}


#define EH 25

XmEdit::~XmEdit()
{
	delete pasteBuffer;
	delete lastVersion;
}

bool XmEdit::createControl(XmControlPane* par)
{
	multiLine = (style & XmSmultiLine ? TRUE : FALSE);
	hScroll = (style & XmSautohscroll ? TRUE : FALSE);
	vScroll = (style & XmSautovscroll ? TRUE : FALSE);

	rci_create_control(RCI_EDIT);

	RciArg* a = new RciArg;
	*a = "";
	wid->setAnswer(a);
	wid->setAutoAnswer();
	wargcount = 0;
	setCallback(XtNcallback, this, CBK(XmEdit, changed), TRUE);
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmEdit::resize(int nw, int nh)
{
	return(XmControl::resize(nw, nh));
}

bool XmEdit::reframe(int nx, int ny, int nw, int nh)
{
	return(XmControl::reframe(nx, ny, nw, nh));
}

void XmEdit::changed(void*)
{
	if((!lastVersion || strcmp(lastVersion, getText())) && userData.receiver && validProc(userData.callback))
	{	genericCallback(wid, (XtPointer )&userData, (XtPointer )NULL);
		delete lastVersion;
		char* cur = getText();
		lastVersion = strcpy(new char[strlen(cur) + 1], cur);
	}
}

XmControl* XmEdit::setText(char* txt)
{
	XmControl::setText(txt);
	return(this);
}

char* _edit_get_text_buffer = NULL;

char* XmEdit::getText()
{
	return(XmControl::getText());
}

bool XmEdit::setEditable(bool sr)
{
	if(wid && wid->isOk())
	{	wid->cmd(RCI_CONFIG, RCI_SENSITIVE);
		wid->arg() = int(sr ? 3 : 4);
		return(wid->execCmd());
	}
	return(FALSE);
}

long XmEdit::getInsertPosition(int* x, int* y)
{
	long p;
	Position px, py;

	if(!wid)
		return(0);
	return(0);
}

bool XmEdit::setInsertPosition(long offs)
{
	if(!wid)
		return(FALSE);
	return(FALSE);
}

bool XmEdit::setInsertPosition(int x, int y)
{
	if(!wid)
		return(FALSE);
	return(FALSE);
}

char* lastSelectionBuffer = NULL;

char* XmEdit::getSelection()
{
	if(!wid)
		return(NULL);
	return(NULL);
}

bool XmEdit::getSelection(long& from, long& to)
{
	if(!wid)
		return(FALSE);
	return(FALSE);
}

bool XmEdit::setSelection(long from, long to)
{
	if(!wid)
		return(FALSE);
	return(FALSE);
}

bool XmEdit::clearSelection()
{
	if(!wid)
		return(FALSE);
	return(FALSE);
}

bool XmEdit::cut()
{
	return(FALSE);
}

bool XmEdit::copy()
{
	return(FALSE);
}

bool XmEdit::paste()
{
	return(FALSE);
}


bool XmListBox::createControl(XmControlPane* par)
{
	rci_create_control(RCI_LISTBOX);

	wargcount = 0;
	parent = par->asObject();
	if(wid && initialContents)
	{	addAll(initialContents);
		initialContents = NULL;
	}
	return(wid ? TRUE : FALSE);
}

void XmListBox::cleanup()
{
}

bool XmListBox::resize(int nw, int nh)
{
	return(XmControl::resize(nw, nh));
}

bool XmListBox::reframe(int nx, int ny, int nw, int nh)		// a 'russian' solution...
{
	return(XmControl::reframe(nx, ny, nw, nh));
}

bool XmListBox::change(char*, char*)
{
	return(FALSE);		// should be implemented...!
}

bool XmListBox::change(int, char*)
{
	return(FALSE);		// should be implemented...!
}

XmListBox* XmListBox::addAll(char** list)
{
	if(!wid->isOk())
		return(this);
	insertAll(-1, list);
	return(this);
}

XmListBox* XmListBox::addAll(char* first,...)
{
	if(!wid)
		return(this);
#ifndef NO_VARARGS
	va_list ap;
	char* anItem = first;
	char* allbuf[100];
	int allcount = 0;

	va_start(ap, first);
	while(anItem)
	{	if(allcount == 100)
			break;
		allbuf[allcount++] = anItem;
		anItem = va_arg(ap, char*);
	}
	va_end(ap);

	allbuf[allcount] = NULL;
	insertAll(-1, allbuf);
#else // NO_VARARGS
	char* onebuf[2];
	onebuf[0] = first;
	onebuf[1] = NULL;
	insertAll(-1, onebuf);
#endif // NO_VARARGS
	return(this);
}

char* tmpListBuf[500];

XmListBox* XmListBox::insertAll(int start, char** list)
{
	if(!wid->isOk())
		return(this);
	wid->cmd(RCI_SETVAL, RCI_LIST);
	wid->arg() = (int)RCI_INSERT;
	wid->arg() = (int)start;
	while(*list)
		wid->arg() = *list++;
	wid->execCmd();
	return(this);
}

XmListBox* XmListBox::insertAll(int start, char* first,...)
{
	if(!wid)
		return(this);
#ifndef NO_VARARGS
	va_list ap;
	char* anItem = first;
	char* allbuf[100];
	int allcount = 0;

	va_start(ap, first);
	while(anItem)
	{	if(allcount == 100)
			break;
		allbuf[allcount++] = anItem;
		anItem = va_arg(ap, char*);
	}
	va_end(ap);

	allbuf[allcount] = NULL;
	insertAll(start, allbuf);
#endif // NO_VARARGS
	return(this);
}

bool XmListBox::removeAll(char** list)
{
	XmString aStr;

	if(!wid->isOk())
		return(FALSE);
	wid->cmd(RCI_SETVAL, RCI_LIST);
	wid->arg() = (int)RCI_REMOVE;
	wid->arg() = (int) -1;
	while(*list)
		wid->arg() = *list++;
	return(wid->execCmd());
}

bool XmListBox::removeAll(char* first,...)
{
	if(!wid)
		return(FALSE);
#ifndef NO_VARARGS
	char* allbuf[100];
	int allcount = 0;

	va_list ap;
	char* anItem = first;
	va_start(ap, first);
	while(anItem)
	{	if(allcount == 100)
			break;
		allbuf[allcount++] = anItem;
		anItem = va_arg(ap, char*);
	}
	va_end(ap);

	allbuf[allcount] = NULL;
	return(allcount ? removeAll(allbuf) : FALSE);
#endif // NO_VARARGS
}

bool XmListBox::removeAll(int* list)
{
	if(!wid->isOk())
		return(FALSE);
	wid->cmd(RCI_SETVAL, RCI_LIST);
	wid->arg() = (int)RCI_REMOVE;
	wid->arg() = (int)0; // ignored...
	while(*list)
		wid->arg() = *list++;
	return(wid->execCmd());
}

bool XmListBox::removeAll(int first,...)
{
	if(!wid)
		return(FALSE);
#ifndef NO_VARARGS
	va_list ap;
	int anIndex = first;
	int allbuf[100];
	int allcount = 0;

	va_start(ap, first);
	while(anIndex)
	{	if(allcount == 100)
			break;
		allbuf[allcount++] = anIndex;
		anIndex = va_arg(ap, int);
	}
	va_end(ap);

	allbuf[allcount] = 0;
	return(allcount ? removeAll(allbuf) : FALSE);
#endif // NO_VARARGS
}

bool XmListBox::clear()
{
	if(!wid->isOk())
		return(FALSE);
	wid->cmd(RCI_SETVAL, RCI_LIST);
	wid->arg() = (int)RCI_CLEAR;
	wid->arg() = (int)0; // ignored...
	return(wid->execCmd());
}	

bool XmListBox::selectText(char* anItem, bool notify)
{
	if(!wid->isOk())
		return(FALSE);
	wid->cmd(RCI_SETVAL, RCI_SELECTION);
	wid->arg() = (int)TRUE;
	wid->arg() = (int)RCI_SEL_ITEM | RCI_SEL_LIST;
	wid->arg() = anItem;
	return(wid->execCmd());
}

bool XmListBox::selectIndex(int anIndex, bool notify)
{
	if(!wid->isOk())
		return(FALSE);
	wid->cmd(RCI_SETVAL, RCI_SELECTION);
	wid->arg() = (int)TRUE;
	wid->arg() = (int)RCI_SEL_INDEX | RCI_SEL_LIST;
	wid->arg() = anIndex;
	return(wid->execCmd());
}

bool XmListBox::deselectText(char* anItem)
{
	if(!wid->isOk())
		return(FALSE);
	wid->cmd(RCI_SETVAL, RCI_SELECTION);
	wid->arg() = (int)FALSE;
	wid->arg() = (int)RCI_SEL_ITEM | RCI_SEL_LIST;
	wid->arg() = anItem;
	return(wid->execCmd());
}

bool XmListBox::deselectIndex(int anIndex)
{
	if(!wid->isOk())
		return(FALSE);
	wid->cmd(RCI_SETVAL, RCI_SELECTION);
	wid->arg() = (int)FALSE;
	wid->arg() = (int)RCI_SEL_INDEX | RCI_SEL_LIST;
	wid->arg() = anIndex;
	return(wid->execCmd());
}

bool XmListBox::deselectAll()
{
	if(!wid->isOk())
		return(FALSE);
	wid->cmd(RCI_SETVAL, RCI_SELECTION);
	wid->arg() = (int)FALSE;
	wid->arg() = (int)RCI_CLEAR;
	return(wid->execCmd());
}

bool XmListBox::setDoubleClickCallback(XmObject* rec, cbProc pr, bool sr, void* cd)
{
	return(setCallback("defaultAction", rec, pr, sr, cd));
}

char** _listbox_items_ptr = NULL;

char** XmListBox::getItems()
{
	_freeStringList(_listbox_items_ptr);

	char** items = NULL;

	if(!wid->isOk())
		return(items);
	wid->cmd(RCI_GETVAL, RCI_LIST);
	wid->arg() = RCI_CONTENTS;
	wid->arg() = (int)0;
	if(wid->execValRequest())
	{	char* anItem;
		items = new char*[wid->getAnswerCount() + 1];
		for(int i = 0; anItem = wid->answer(i); i++)
			items[i] = _mkstr(anItem);
	}
	_listbox_items_ptr = items;
	return(items);
}

int XmListBox::getItemCount()
{
	int count = 0;

	if(!wid->isOk())
		return(0);
	wid->cmd(RCI_GETVAL, RCI_LIST);
	wid->arg() = RCI_LENGTH;
	if(wid->execValRequest())
		count = wid->answer(0);
	return(count);
}

int XmListBox::selectedCount()
{
	int count = 0;

	if(!wid->isOk())
		return(0);
	wid->cmd(RCI_GETVAL, RCI_SELECTION);
	wid->arg() = RCI_SEL_COUNT;
	if(wid->execValRequest())
		count = wid->answer(0);
	return(count);
}

char** XmListBox::selectedItems()
{
	_freeStringList(_listbox_items_ptr);

	int numSelected = 0;
	char** items = NULL;

	if(!wid->isOk())
		return(items);
	wid->cmd(RCI_GETVAL, RCI_SELECTION);
	wid->arg() = RCI_SEL_ITEM;
	if(wid->execValRequest())
	{	char* anItem;
		items = new char*[(numSelected = wid->getAnswerCount()) + 1];
		for(int i = 0; anItem = wid->answer(i); i++)
			items[i] = _mkstr(anItem);
	}
	else
		items = new char*[1];
	items[numSelected] = NULL;
	_listbox_items_ptr = items;
	return(items);
}

int* _listbox_indices_ptr = NULL;

int* XmListBox::selectedIndices()
{
	delete _listbox_indices_ptr;
	_listbox_indices_ptr = NULL;

	int numSelected = 0;
	int* items = NULL;

	if(!wid->isOk())
		return(items);
	wid->cmd(RCI_GETVAL, RCI_SELECTION);
	wid->arg() = RCI_SEL_INDEX;
	if(wid->execValRequest())
	{	int anIndex;
		items = new int[(numSelected = wid->getAnswerCount()) + 1];
		for(int i = 0; anIndex = wid->answer(i); i++)
			items[i] = anIndex;
	}
	else
		items = new int[1];
	items[numSelected] = 0;
	_listbox_indices_ptr = items;
	return(items);
}


#ifdef ASCII
#define CAW 25
#define CAH 25
#define CAS 2
#else
#define CAW 25
#define CAH 25
#define CAS 2
#endif

#ifdef COMBO_PROC_CAST
#undef CB
typedef void (XmComboBox::*comboProc)(void*);
inline cbProc makeCbProc(comboProc p)
{ cbProc px; memcpy(&px, &p, sizeof(cbProc)); return(px); }
#define CB(x) makeCbProc(&x)
#endif


 
XmComboBox::XmComboBox(char* name, int x, int y, int w, int h, xmStyle s) :
	XmGroupBox(name, x, y, w, (s & XmSsimple) ? h : CAH, s),
	XmPushButton(name, x + w - CAW, y, CAW, CAH),
	XmEdit(name, x, y, w - CAW - CAS, CAH),
	XmListBox(name, x + CAW, y + CAH, w - CAW, (h > 2 * CAH) ? h - CAH : 4 * CAH)
{
	popup = NULL;
	cbStyle = ((s & XmSdropdownlist) ? DROPDOWNLIST : ((s & XmSsimple) ? SIMPLE : DROPDOWN));
	lbMapped = FALSE;
	ignoreSelect = FALSE;
}

XmComboBox::~XmComboBox()
{
	MEMBER(XmEdit, resetParent)();
	MEMBER(XmPushButton, resetParent)();
	MEMBER(XmListBox, resetParent)();
}

bool XmComboBox::createControl(XmControlPane* par)
{
	Widget gwid = MEMBER(XmGroupBox, wid);

	delete MEMBER(XmPushButton, wid);
	MEMBER(XmPushButton, wid) = gwid;
	delete MEMBER(XmEdit, wid);
	MEMBER(XmEdit, wid) = gwid;
	delete MEMBER(XmListBox, wid);
	MEMBER(XmListBox, wid) = gwid;


	gwid->cmd(RCI_CREATE, RCI_COMBOBOX);
	gwid->arg() = par->handle()->getId();
	gwid->arg() = (int)MEMBER(XmGroupBox, cx);
	gwid->arg() = (int)MEMBER(XmGroupBox, cy);
	gwid->arg() = (int)MEMBER(XmGroupBox, cw);
	gwid->arg() = (int)MEMBER(XmGroupBox, ch);
	gwid->arg() = (unsigned long)MEMBER(XmGroupBox, style);
	gwid->execCreate();

	MEMBER(XmEdit, setCallback)(XtNcallback,
		(XmEdit*)this, CBK(XmEdit, changed), TRUE);

	MEMBER(XmGroupBox, wargcount) = 0;
	MEMBER(XmGroupBox, parent) = par->asObject();
	if(gwid->isOk() && MEMBER(XmListBox, initialContents))
	{	MEMBER(XmListBox, addAll)(initialContents);
		initialContents = NULL;
	}
	return(gwid->isOk() ? TRUE : FALSE);
}

void XmComboBox::makeRelativeTo(XmGroupBox* aGroup)
{
	MEMBER(XmGroupBox, makeRelativeTo)(aGroup);
}

void XmComboBox::showList(bool)
{
}

void XmComboBox::selectArrow(void*)
{
}

void XmComboBox::changeText(void*)
{
}

void XmComboBox::selectInList(void*)
{
}

void XmComboBox::cleanupCb(void*)
{
}

bool XmComboBox::realize()
{
	return(MEMBER(XmGroupBox, realize)());
}

bool XmComboBox::move(int nx, int ny)
{
	return(MEMBER(XmGroupBox, move)(nx, ny));
}

bool XmComboBox::resize(int x, int y)
{
	return(MEMBER(XmGroupBox, resize)(x, y));
}

bool XmComboBox::reframe(int x, int y, int w, int h)
{
	return(MEMBER(XmGroupBox, reframe)(x, y, w, h));
}

XmControl* XmComboBox::setFocus()	{ return((XmGroupBox* )this); }

XmControl* XmComboBox::disable()
{
	MEMBER(XmEdit, disable)();
	return((XmGroupBox* )this);
}

XmControl* XmComboBox::enable()
{
	MEMBER(XmEdit, enable)();
	return((XmGroupBox* )this);
}
