//
// showimg.C  last changed Aug. 29, 1994
// A simple viewer for GIF and X11 Bitmap files.
// This application should run under Motif and Xaw
//
// Usage: XXshowimg [filename] (where XX can be xm or aw)
//
// If no filename is given showimg tries to open 'images.lst'
// Note that GIF files must have a name ending in lowercase '.gif'
//
// It will run under TIP when subpanes, toolbar and image support
// has been added to the TIP implementation (probably end 1995)
//

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <xmObject.h>

class TestWindow : public XmWindow
{
	XmStaticImage* img;
	char imgNames[100][100];
	int imgCount, curImg;
public:
	TestWindow();

	void cmd(char*);
	void openNew(void*);
	void close(void*);
	void about(void*);

	void quit(void*);
};


void XmApp::initialize()
{
	(new TestWindow)->open();
};

TestWindow::TestWindow() : XmWindow("Test")
{
	char* fn = "images.lst";

	if(App->getCmdArg(1))
		fn = App->getCmdArg(1);
	ifstream in(fn);
	if(!in.good())
	{	cout 	<< App->getCmdArg(0) << ": invalid file \""
			<< fn << "\"\n";
		quit(NULL);
	}
	imgCount = curImg = 0;
	while(in.good())
	{	in.getline(imgNames[imgCount], 32);
		if(!strlen(imgNames[imgCount]))
			break;
		imgCount++;
	}
	imgCount--;

	setInitWindowSize(300, 300, 500, 400);

	XmDropdownMenu* m = createDropdownMenu();

	m->addLabels("&File", "&Misc", NULL);
	m->setCurrentLabel("File");
	m->addItems(
	  Entry("&Open", CBK(TestWindow, openNew)),
	  Entry("&Close", CBK(TestWindow, close)),
	  NULLENTRY);
	m->addSeparator();
	m->addItem(Entry("E&xit", CBK(TestWindow, quit)));
	m->setCurrentLabel("Misc");
	m->addItem(Entry("&About...", CBK(TestWindow, about)));

	addSubpane(img = new XmStaticImage("img"));
	img->setImage(getRuntimeImage(imgNames[curImg]));

	XmToolBar* tb;

	tb = addToolbar(XmSleft);
	tb->add((new XmPushButton("&Next")), this, CBK(TestWindow, cmd), CB_OBJ_NAME);
	tb->add((new XmPushButton("&Prev")), this, CBK(TestWindow, cmd), CB_OBJ_NAME);
	tb->pushButton("Prev")->disable();
}

void TestWindow::cmd(char* n)
{
	switch(*n)
	{	case 'N':
		curImg++;
		break;
		case 'P':
		curImg--;
		break;
	}
	if(curImg > imgCount - 1)
		toolbar(XmSleft)->pushButton("Next")->disable();
	else
		toolbar(XmSleft)->pushButton("Next")->enable();
	if(curImg == 0)
		toolbar(XmSleft)->pushButton("Prev")->disable();
	else
		toolbar(XmSleft)->pushButton("Prev")->enable();
	img->setImage(getRuntimeImage(imgNames[curImg]));
}

void TestWindow::openNew(void*)
{
	(new TestWindow)->open();
}

void TestWindow::close(void*)
{
	delete this;
}

void TestWindow::about(void*)
{
	(new XmMsgBox("Xm++ image view demo.", "About", XmSmboxInfo))->showMsg();
}

void TestWindow::quit(void*)
{
	App->quit();
}





