/* ****************************** -*-c++-*- *******************************/
/* ************************************************************************ 
 *         The Amulet User Interface Development Environment              *
 * ************************************************************************
 * This code was written as part of the Amulet project at                 *
 * Carnegie Mellon University, and has been placed in the public          *
 * domain.  If you are using this code or any part of Amulet,             *
 * please contact amulet@cs.cmu.edu to be put on the mailing list.        *
 * ************************************************************************/

#ifndef OPAL_H
#define OPAL_H

#include <am_inc.h>

#include GDEFS__H
#include FORMULA__H

extern Am_Style Am_Red;
extern Am_Style Am_Green;
extern Am_Style Am_Blue;
extern Am_Style Am_Yellow;
extern Am_Style Am_Purple;
extern Am_Style Am_Cyan;
extern Am_Style Am_Orange;
extern Am_Style Am_Black;
extern Am_Style Am_White;
extern Am_Style Am_Amulet_Purple;

extern Am_Style Am_Motif_Gray;
extern Am_Style Am_Motif_Light_Gray;
extern Am_Style Am_Motif_Blue;
extern Am_Style Am_Motif_Light_Blue;
extern Am_Style Am_Motif_Green;
extern Am_Style Am_Motif_Light_Green;
extern Am_Style Am_Motif_Orange;
extern Am_Style Am_Motif_Light_Orange;

extern Am_Style Am_Thin_Line;
extern Am_Style Am_Line_0;
extern Am_Style Am_Line_1;
extern Am_Style Am_Line_2;
extern Am_Style Am_Line_4;
extern Am_Style Am_Line_8;
extern Am_Style Am_Dotted_Line;
extern Am_Style Am_Dashed_Line;

extern Am_Style Am_Gray_Stipple;
extern Am_Style Am_Opaque_Gray_Stipple;
extern Am_Style Am_Light_Gray_Stipple;
extern Am_Style Am_Dark_Gray_Stipple;
extern Am_Style Am_Diamond_Stipple;
extern Am_Style Am_Opaque_Diamond_Stipple;

extern Am_Font Am_Default_Font;

extern Am_Object Am_Screen;

extern Am_Object Am_Graphical_Object;
extern Am_Object Am_Window;
extern Am_Object Am_Rectangle;
extern Am_Object Am_Roundtangle;
extern Am_Object Am_Line;
extern Am_Object Am_Arrow;
extern Am_Object Am_Polygon;
extern Am_Object Am_Arc;
extern Am_Object Am_Text;
extern Am_Object Am_Bitmap;

extern Am_Object Am_Group;
extern Am_Object Am_Map;
extern Am_Object Am_Resize_Parts_Group;

// Store in Group or Map's Am_LAYOUT slot for automatic layout.
extern Am_Formula Am_Horizontal_Layout;
extern Am_Formula Am_Vertical_Layout;

// Other useful constraints for laying things out.
extern Am_Formula Am_Fill_To_Bottom;
extern Am_Formula Am_Fill_To_Right;
extern Am_Formula Am_Width_Of_Parts;
extern Am_Formula Am_Height_Of_Parts;
extern Am_Formula Am_Center_X_Is_Center_Of;
extern Am_Formula Am_Center_Y_Is_Center_Of;
extern Am_Formula Am_Center_X_Is_Center_Of_Owner;
extern Am_Formula Am_Center_Y_Is_Center_Of_Owner;
extern Am_Formula Am_Right_Is_Right_Of_Owner;
extern Am_Formula Am_Bottom_Is_Bottom_Of_Owner;

extern Am_Constraint* Am_Same_As (Am_Slot_Key key);
extern Am_Constraint* Am_From_Owner (Am_Slot_Key key);
extern Am_Constraint* Am_From_Part (Am_Slot_Key part, Am_Slot_Key key);
extern Am_Constraint* Am_From_Sibling (Am_Slot_Key sibling, Am_Slot_Key key);

// For Am_H_ALIGN and Am_V_ALIGN slots.
#define Am_CENTER_ALIGN 0
#define Am_TOP_ALIGN    1
#define Am_BOTTOM_ALIGN 2
#define Am_LEFT_ALIGN   1
#define Am_RIGHT_ALIGN  2

// For Am_FIXED_WIDTH and Am_FIXED_HEIGHT slots.
#define Am_NOT_FIXED_SIZE 0
#define Am_MAX_FIXED_SIZE 1

// For Am_Text's Am_CURSOR_INDEX
#define Am_NO_CURSOR -1


extern void Am_Initialize ();

extern void Am_Cleanup ();

extern void Am_Beep (Am_Object window = Am_No_Object);

extern void Am_Move_Object (Am_Object object, Am_Object ref_object,
                            bool above = true);
extern void Am_To_Top (Am_Object object);
extern void Am_To_Bottom (Am_Object object);

extern Am_Object Am_Create_Screen (const char* display_name);

extern bool Am_Do_Events (bool wait = false);
extern void Am_Wait_For_Event ();
extern void Am_Main_Event_Loop ();

extern void Am_Exit_Main_Event_Loop ();

//Check whether point is inside all the owners of object, up to the
//window.  Also validates that all of the owners are visible.
//  If not, returns false.  Use this to make sure that not pressing
//  outside of an owner since the other operations below do NOT check
//  this.
extern bool Am_Point_In_All_Owners(Am_Object in_obj, int x, int y,
				   Am_Object ref_obj);

// Check whether the point is inside the object.  Ignores
//   covering (i.e., just checks whether point is inside the
//   object even if the object is covered.  If inside, returns the
//   object, otherwise returns NULL (0)
//  The coordinate system of x and y is defined w.r.t. ref_obj
extern Am_Object Am_Point_In_Obj (Am_Object in_obj, int x, int y,
				  Am_Object ref_obj);
 
// Find the front-most immediate child object at the specified
//  location.  If none, then if want_self then if inside in_obj,
//  returns in_obj.   If NOT want_self or NOT inside in_obj, returns
//  Am_No_Object. The coordinate system of x and y is defined
//  w.r.t. ref_obj.   If want_groups is true, the finds the
//   leaf-most element even if it is a group.  If want_groups is
//   false, then will not return a group (if x,y is not over a
//   "primitive" object, returns Am_No_Object)
extern Am_Object Am_Point_In_Part (Am_Object in_obj, int x, int y,
				   Am_Object ref_obj,
				   bool want_self = false,
				   bool want_groups = true);
 
// Find the leaf-most object at the specified location.  If x,y is inside
//   in_obj but not over a leaf, then if want_self returns in_obj,
//   otherwise returns Am_No_Object.  If want_groups is true, the finds the
//   leaf-most element even if it is a group.  If want_groups is
//   false, then will not return a group (if x,y is not over a
//   "primitive" object, returns Am_No_Object)
// The coordinate system of x and y is defined w.r.t. ref_obj
extern Am_Object Am_Point_In_Leaf (Am_Object in_obj, int x, int y,
				   Am_Object ref_obj,
				   bool want_self = true,
				   bool want_groups = true);

// Converts a point in one object's coordinate system, to that of another
// object.  If the objects are not comparable (like being on different screens
// or not being on a screen at all) then the function will return false.
// Otherwise, it will return true and dest_x and dest_y will contain the
// converted coordinates.  Note that the coordinates are for the
// INSIDE of dest_obj.  This means that if "obj" was at src_x, src_y
// in src_obj and you remove it from src_obj and add it to dest_obj at
// dest_x, dest_y then it will be at the same physical screen position.
// Providing a Am_Constraint_Context parameter can be used in formulas
// to make the formula dependent on the relative positions of the objects
extern bool Am_Translate_Coordinates
           (const Am_Object& src_obj, int src_x, int src_y,
            const Am_Object& dest_obj, int& dest_x, int& dest_y,
            Am_Constraint_Context& cc = *Am_Empty_Constraint_Context);

#define Am_Define_Style_Formula(formula_name) \
     Am_Define_Formula (Am_Wrapper*, formula_name)
#define Am_Define_Value_List_Formula(formula_name) \
     Am_Define_Formula (Am_Wrapper*, formula_name)
#define Am_Define_Font_Formula(formula_name) \
     Am_Define_Formula (Am_Wrapper*, formula_name)
#define Am_Define_Point_List_Formula(formula_name) \
     Am_Define_Formula (Am_Wrapper*, formula_name)
#define Am_Define_Image_Formula(formula_name) \
     Am_Define_Formula (Am_Wrapper*, formula_name)
#define Am_Define_Cursor_Formula(formula_name) \
     Am_Define_Formula (Am_Wrapper*, formula_name)

//methods for the Am_DESTROY_WINDOW_METHOD slot of windows
extern Am_Object_Method Am_Window_Hide_Method; //set visible to false
extern Am_Object_Method Am_Window_Destroy_And_Exit_Method;  //exit MEL
extern Am_Object_Method Am_Default_Window_Destroy_Method; 
         //destroy and exit MEL if no windows are left


#endif
