/* ************************************************************************ 
 *         The Amulet User Interface Development Environment              *
 * ************************************************************************
 * This code was written as part of the Amulet project at                 *
 * Carnegie Mellon University, and has been placed in the public          *
 * domain.  If you are using this code or any part of Amulet,             *
 * please contact amulet@cs.cmu.edu to be put on the mailing list.        *
 * ************************************************************************/

#ifndef STD_VALUE_H
#define STD_VALUE_H

#include <am_inc.h>

#include TYPES__H

class Am_Double_Data : public Am_Wrapper {
  Am_WRAPPER_DATA_DECL (Am_Double)
 public:
  operator== (Am_Double_Data& test_value) const;
  operator double () const;
  Am_Double_Data (double value);

 private:
  double value;
};

class Am_String_Data : public Am_Wrapper {
  Am_WRAPPER_DATA_DECL (Am_String)
 public:
  operator== (Am_String_Data& test_value) const;
  operator== (const char* test_value) const;
  operator const char* () const;
  operator char* () const;
  Am_String_Data (const char* value, bool copy = true);
  ~Am_String_Data ();
  virtual void Print_Name (ostream& out);

 private:
  const char* value;
};

#endif
